/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Loteamento;
import br.com.elotech.tributos.repository.LoteamentoRepository;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.ConfiguracaoInscricaoCadastralService;
import br.com.elotech.tributos.service.SetorQuadraService;
import br.com.elotech.tributos.util.UsuarioUtils;
import java.time.LocalDate;
import java.util.List;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class LoteamentoService
extends CrudService<Loteamento, Long> {
    private final CadastroImobiliarioService cadastroImobiliarioService;
    private final ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService;
    private final SetorQuadraService setorQuadraService;
    private final LoteamentoRepository loteamentoRepository;

    public LoteamentoService(CadastroImobiliarioService cadastroImobiliarioService, ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService, SetorQuadraService setorQuadraService, LoteamentoRepository loteamentoRepository) {
        this.cadastroImobiliarioService = cadastroImobiliarioService;
        this.configuracaoInscricaoCadastralService = configuracaoInscricaoCadastralService;
        this.setorQuadraService = setorQuadraService;
        this.loteamentoRepository = loteamentoRepository;
    }

    protected void beforeSave(Loteamento entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        entity.setUsuario(UsuarioUtils.getUsuarioAise());
        entity.setDataAlteracao(LocalDate.now());
        entity.setChildrenId();
    }

    protected void beforeDelete(Loteamento entity, Authentication authentication) {
        super.beforeDelete((EloEntity)entity, authentication);
        List quadras = this.setorQuadraService.findByLoteamentoId(entity.getId());
        if (!quadras.isEmpty()) {
            throw new EloValidationException(String.format("O loteamento %d j\u00e1 possui v\u00ednculo com a %s", entity.getLoteamento(), this.configuracaoInscricaoCadastralService.getConfiguracao().getQuadra().getDescricao()));
        }
        if (Boolean.TRUE.equals(this.cadastroImobiliarioService.existsCadastroImobiliarioAssociadoLoteamento(entity.getId()))) {
            throw new EloValidationException(String.format("O loteamento %d j\u00e1 possui v\u00ednculo com o Cadastro Imobili\u00e1rio", entity.getLoteamento()));
        }
    }

    public Loteamento findByLoteamento(Long codigoLoteamento) {
        return (Loteamento)this.loteamentoRepository.findByLoteamento(codigoLoteamento).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Loteamento com o c\u00f3digo '%d'.", codigoLoteamento)));
    }

    public Loteamento findBySetorDistritoDistritoAndSetorSetorAndLoteamento(String distrito, String setor, Long loteamento) {
        return this.loteamentoRepository.findBySetorDistritoDistritoAndSetorSetorAndLoteamento(distrito, setor, loteamento);
    }
}

