/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.rsql.RsqlSpecification;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.parcelamento.LoteParcelamentoReajuste;
import br.com.elotech.tributos.domain.parcelamento.LoteParcelamentoReajusteItem;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.dto.parcelamento.AtualizacaoMonetariaDTO;
import br.com.elotech.tributos.dto.parcelamento.SituacaoReajusteParcelamentoLote;
import br.com.elotech.tributos.dto.parcelamento.SituacaoReajusteParcelamentoLoteItem;
import br.com.elotech.tributos.repository.parcelamento.LoteParcelamentoReajusteItemRepository;
import br.com.elotech.tributos.repository.parcelamento.LoteParcelamentoReajusteRepository;
import br.com.elotech.tributos.service.ParcelamentoService;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class LoteParcelamentoReajusteService
extends CrudService<LoteParcelamentoReajuste, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoteParcelamentoReajusteService.class);
    private ParcelamentoService parcelamentoService;
    private LoteParcelamentoReajusteRepository loteParcelamentoReajusteRepository;
    private LoteParcelamentoReajusteItemRepository loteParcelamentoReajusteItemRepository;

    public LoteParcelamentoReajuste createLoteParcelamentoReajuste(AtualizacaoMonetariaDTO atualizacaoMonetariaDTO, String usuario) {
        LoteParcelamentoReajuste loteParcelamentoReajuste = new LoteParcelamentoReajuste();
        loteParcelamentoReajuste.setUsuario(usuario);
        loteParcelamentoReajuste.setDataCriacao(LocalDate.now());
        loteParcelamentoReajuste.setSituacao(SituacaoReajusteParcelamentoLote.CREATED);
        loteParcelamentoReajuste.setObservacao(atualizacaoMonetariaDTO.getObservacao());
        List parcelamentos = this.getParcelamentos(atualizacaoMonetariaDTO);
        List loteParcelamentoReajusteItems = parcelamentos.stream().map(p -> {
            LoteParcelamentoReajusteItem loteParcelamentoReajusteItem = new LoteParcelamentoReajusteItem();
            loteParcelamentoReajusteItem.setSituacaoReajusteParcelamentoLote(SituacaoReajusteParcelamentoLoteItem.CREATED);
            loteParcelamentoReajusteItem.setLoteParcelamentoReajuste(loteParcelamentoReajuste);
            loteParcelamentoReajusteItem.setParcelamento(p);
            loteParcelamentoReajusteItem.setAno(atualizacaoMonetariaDTO.getAno());
            loteParcelamentoReajusteItem.setMes(atualizacaoMonetariaDTO.getMes());
            return loteParcelamentoReajusteItem;
        }).collect(Collectors.toList());
        loteParcelamentoReajuste.setItens(loteParcelamentoReajusteItems);
        return (LoteParcelamentoReajuste)this.loteParcelamentoReajusteRepository.save((Object)loteParcelamentoReajuste);
    }

    private List<Parcelamento> getParcelamentos(AtualizacaoMonetariaDTO atualizacaoMonetariaDTO) {
        String search = atualizacaoMonetariaDTO.getSearch();
        if (atualizacaoMonetariaDTO.isEnviaLote().booleanValue()) {
            if (search == null || search.trim().isEmpty()) {
                search = "id!=null";
            }
        } else {
            search = atualizacaoMonetariaDTO.getIdsRsqlSearch();
        }
        return this.parcelamentoService.findAll((Specification)new RsqlSpecification(this.getEm(), search));
    }

    public Page<LoteParcelamentoReajusteItem> searchItens(Long idParcelamento, String search, Pageable pageable) {
        String queryIdParcelamento = String.format("loteParcelamentoReajuste.id==%d", idParcelamento);
        String queryFinal = StringUtils.isBlank((CharSequence)search) ? queryIdParcelamento : String.format("(%s) and (%s)", queryIdParcelamento, search);
        Specification specification = RsqlUtils.createSpecFrom((EntityManager)this.getEm(), (String)queryFinal);
        return this.loteParcelamentoReajusteItemRepository.findAll(specification, pageable);
    }

    @Generated
    public LoteParcelamentoReajusteService(ParcelamentoService parcelamentoService, LoteParcelamentoReajusteRepository loteParcelamentoReajusteRepository, LoteParcelamentoReajusteItemRepository loteParcelamentoReajusteItemRepository) {
        this.parcelamentoService = parcelamentoService;
        this.loteParcelamentoReajusteRepository = loteParcelamentoReajusteRepository;
        this.loteParcelamentoReajusteItemRepository = loteParcelamentoReajusteItemRepository;
    }
}

