/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.domain.Cartorio;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.Livro;
import br.com.elotech.tributos.domain.LivroId;
import br.com.elotech.tributos.dto.DebitoConsultaCancelamentoPorParcelaDTO;
import br.com.elotech.tributos.dto.DebitoConsultaCreditoPorParcelaDTO;
import br.com.elotech.tributos.dto.DebitoConsultaDTO;
import br.com.elotech.tributos.dto.DebitoConsultaTributoPorParcelaDTO;
import br.com.elotech.tributos.dto.DebitoDetalheParcelasDTO;
import br.com.elotech.tributos.dto.DebitoDividaAtivaAvulsaDTO;
import br.com.elotech.tributos.dto.DebitoGeracaoDividaAtivaAvulsaDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoDividaAtivaAvulsaDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.dto.debito.DebitoSubdividaDTO;
import br.com.elotech.tributos.dto.dividaativa.LivroDTO;
import br.com.elotech.tributos.params.DebitoParams;
import br.com.elotech.tributos.params.NextSubdividaValueParams;
import br.com.elotech.tributos.report.loader.EspelhoCarneParamLoader;
import br.com.elotech.tributos.report.loader.HistoricoDebitoParamLoader;
import br.com.elotech.tributos.repository.CartorioRepository;
import br.com.elotech.tributos.repository.DebitoParcelaTributoRepository;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.repository.LivroRepository;
import br.com.elotech.tributos.service.exception.DebitoNotFoundException;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DebitoService
extends ReadOnlyService<Debito, Long> {
    private final DebitoParcelaTributoRepository debitoParcelaTributoRepository;
    private final DebitoRepository debitoRepository;
    private final HistoricoDebitoParamLoader historicoDebitoParamLoader;
    private final EspelhoCarneParamLoader espelhoCarneParamLoader;
    private final CartorioRepository cartorioRepository;
    private final LivroRepository livroRepository;

    public DebitoService(DebitoParcelaTributoRepository debitoParcelaTributoRepository, DebitoRepository debitoRepository, HistoricoDebitoParamLoader historicoDebitoParamLoader, CartorioRepository cartorioRepository, LivroRepository livroRepository, EspelhoCarneParamLoader espelhoCarneParamLoader) {
        this.debitoParcelaTributoRepository = debitoParcelaTributoRepository;
        this.debitoRepository = debitoRepository;
        this.historicoDebitoParamLoader = historicoDebitoParamLoader;
        this.cartorioRepository = cartorioRepository;
        this.livroRepository = livroRepository;
        this.espelhoCarneParamLoader = espelhoCarneParamLoader;
    }

    public DebitoConsultaDTO getDebitosConsulta(Long id) {
        DebitoConsultaDTO debitoConsultaDTO = this.debitoRepository.findDebitoConsulta(id);
        debitoConsultaDTO.setDebitoConsultaParcela(this.debitoRepository.findDebitosParcelasConsulta(id));
        debitoConsultaDTO.setDebitoConsultaTributo(this.debitoRepository.findDebitosTributosConsulta(id));
        return debitoConsultaDTO;
    }

    public DebitoDetalheParcelasDTO findDebitosParcelasByIdAndParcela(Long id, Long parcela) {
        DebitoDetalheParcelasDTO debitoDetalheParcelasDTO = this.debitoRepository.findDebitosParcelasByIdAndParcela(id, parcela);
        if (Objects.nonNull(debitoDetalheParcelasDTO.getIdCartorio())) {
            Cartorio cartorio = (Cartorio)this.cartorioRepository.findOne((Object)debitoDetalheParcelasDTO.getIdCartorio());
            debitoDetalheParcelasDTO.setCartorio(cartorio);
        }
        if (Objects.nonNull(debitoDetalheParcelasDTO.getNumeroLivro())) {
            LivroId livroId = LivroId.of((Long)debitoDetalheParcelasDTO.getEntidade(), (Long)debitoDetalheParcelasDTO.getExercicioLivroId(), (Long)debitoDetalheParcelasDTO.getNumeroLivro());
            Livro livro = (Livro)this.livroRepository.findOne((Object)livroId);
            debitoDetalheParcelasDTO.setLivro(LivroDTO.of((Livro)livro));
        }
        return debitoDetalheParcelasDTO;
    }

    public ImprimirRelatorioDTO getImprimirHitoricoDebito(DebitoParams params) {
        ImprimirRelatorioDTO imprimirRelatorioDTO = new ImprimirRelatorioDTO();
        imprimirRelatorioDTO.setRelatorio(Integer.valueOf(188));
        imprimirRelatorioDTO.setFiltro(String.format(" td.Entidade = %d and td.Exercicio = %d and td.TipoCadastro = %d and td.CadastroGeral = %d and td.GuiaRecolhimento = %d and td.SubDivida = %d ", params.getEntidade(), params.getExercicio(), params.getTipoCadastro(), params.getCadastroGeral(), params.getDivida(), params.getSubDivida()));
        imprimirRelatorioDTO.setListParametros(this.historicoDebitoParamLoader.load());
        imprimirRelatorioDTO.setSubReports(this.createSubreportImprimirHistoricoDebito(imprimirRelatorioDTO.getFiltro()));
        return imprimirRelatorioDTO;
    }

    private SubReportDTO createSubreportImprimirHistoricoDebito(String filtro) {
        SubReportDTO subReportDTO = new SubReportDTO();
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("PARCELAS", filtro), new SubReportItemDTO("RECEITAS", filtro), new SubReportItemDTO("CONTENCIOSO", filtro), new SubReportItemDTO("AUTOINFRACAO", filtro), new SubReportItemDTO("debcontauto_obs", filtro)}));
        return subReportDTO;
    }

    public ImprimirRelatorioDTO getImprimirEspelhoCarne(DebitoParams params) {
        ImprimirRelatorioDTO imprimirRelatorioDTO = new ImprimirRelatorioDTO();
        imprimirRelatorioDTO.setRelatorio(Integer.valueOf(248));
        imprimirRelatorioDTO.setFiltro(String.format(" td.Exercicio = %d and td.TipoCadastro = %d and td.CadastroGeral = %d and td.GuiaRecolhimento = %d and td.SubDivida = %d ", params.getExercicio(), params.getTipoCadastro(), params.getCadastroGeral(), params.getDivida(), params.getSubDivida()));
        imprimirRelatorioDTO.setListParametros(this.espelhoCarneParamLoader.load());
        imprimirRelatorioDTO.setSubReports(this.createSubreportImprimirEspelhoCarne(imprimirRelatorioDTO.getFiltro()));
        return imprimirRelatorioDTO;
    }

    private SubReportDTO createSubreportImprimirEspelhoCarne(String filtro) {
        SubReportDTO subReportDTO = new SubReportDTO();
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("RECEITAS", filtro), new SubReportItemDTO("PARCELAS", filtro), new SubReportItemDTO("TotalCarne", filtro)}));
        return subReportDTO;
    }

    public List<DebitoConsultaCancelamentoPorParcelaDTO> findCancelamentosPorParcela(Debito debito, Long parcela) {
        return this.debitoRepository.findCancelamentosPorParcela(debito, parcela);
    }

    public List<DebitoConsultaCreditoPorParcelaDTO> findCreditosPorParcela(Debito debito, Long parcela) {
        return this.debitoRepository.findCreditosPorParcelas(debito, parcela);
    }

    public List<DebitoConsultaTributoPorParcelaDTO> findTributosPorParcela(Debito debito, Long parcela) {
        return this.debitoRepository.findTributosPorParcelas(debito, parcela);
    }

    public Long getNextValueSubdivida(NextSubdividaValueParams params) {
        return this.debitoRepository.findTopByTipoCadastroAndCadastroGeralCadastroGeralAndExercicioAndDividaDividaOrderBySubDividaDesc(params.getTipoCadastro(), params.getCadastroGeral(), params.getExercicio(), params.getDivida()).map(Debito::getSubDivida).map(subdivida -> subdivida + 1L).orElse(0L);
    }

    public Optional<Debito> findByCompositeKey(Long entidade, Long exercicio, Long tipoCadastro, Long cadastroGeral, Long divida, Long subDivida) {
        return this.debitoRepository.findByCompositeKey(entidade, exercicio, tipoCadastro, cadastroGeral, divida, subDivida);
    }

    @Transactional
    public Debito save(Debito debito) {
        Debito entity = (Debito)this.debitoRepository.save((Object)debito);
        this.debitoParcelaTributoRepository.saveAll((Iterable)debito.getAllDebitoParcelaTributo());
        return entity;
    }

    public List<DebitoIdDTO> findDebitosIdRelacionadosPagamento(Long entidade, Long exercicioPagamento, Long pagamento) {
        return this.debitoRepository.findDebitosIdRelacionadosPagamento(entidade, exercicioPagamento, pagamento);
    }

    public Long totalDebitosConstituidos(FiltroConsultaDebitoDTO filtro) {
        Long total = this.debitoRepository.totalDebitosConstituidos(filtro);
        if (total > 0L) {
            return total;
        }
        throw new EloValidationException("O filtro informado n\u00e3o encontrou nenhum registro.");
    }

    @Transactional
    public void constituirDebitosCalculo(Long idCalculo) {
        this.debitoRepository.constituirDebitosCalculo(idCalculo);
    }

    public List<DebitoDividaAtivaAvulsaDTO> findDebitosDividaAtivaAvulsa(FiltroConsultaDebitoDividaAtivaAvulsaDTO filtro) {
        return this.debitoRepository.findDebitosDividaAtivaAvulsa(filtro);
    }

    public List<DebitoGeracaoDividaAtivaAvulsaDTO> findDebitogeracaoCDAAvulsa(DebitoDividaAtivaAvulsaDTO debito, Long entidade) {
        return this.debitoRepository.findDebitogeracaoCDAAvulsa(debito, entidade);
    }

    public List<DebitoSubdividaDTO> getDebitoSubdividas(Long id) {
        Debito debito = (Debito)this.debitoRepository.findById((Object)id).orElseThrow(() -> new DebitoNotFoundException(id));
        List debitoList = this.debitoRepository.findByTipoCadastroAndCadastroGeralCadastroGeralAndExercicioAndGuiaRecolhimento(debito.getTipoCadastro(), debito.getCadastroGeral().getCadastroGeral(), debito.getExercicio(), debito.getGuiaRecolhimento());
        return debitoList.stream().map(DebitoSubdividaDTO::from).collect(Collectors.toList());
    }

    public List<DebitoSubdividaDTO> getDebitoSubdividasByCompositeKey(Long exercicio, Long tipoCadastro, Long cadastroGeral, Long divida) {
        List debitoList = this.debitoRepository.findByTipoCadastroAndCadastroGeralCadastroGeralAndExercicioAndGuiaRecolhimento(tipoCadastro, cadastroGeral, exercicio, divida);
        return debitoList.stream().map(DebitoSubdividaDTO::from).collect(Collectors.toList());
    }
}

