/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CreditoContribuinte;
import br.com.elotech.tributos.domain.CreditoContribuinteId;
import br.com.elotech.tributos.dto.CreditoContribuinteDTO;
import br.com.elotech.tributos.dto.CreditoContribuintePesquisaDTO;
import br.com.elotech.tributos.dto.FiltroCreditoContribuinteDTO;
import br.com.elotech.tributos.repository.CreditoContribuinteRepository;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class CreditoContribuinteService
extends CrudService<CreditoContribuinte, CreditoContribuinteId> {
    private final CreditoContribuinteRepository creditoContribuinteRepository;

    public CreditoContribuinteService(CreditoContribuinteRepository creditoContribuinteRepository) {
        this.creditoContribuinteRepository = creditoContribuinteRepository;
    }

    public Page<CreditoContribuintePesquisaDTO> findCreditos(FiltroCreditoContribuinteDTO filtroCreditoContribuinte, Pageable pageable) {
        return this.creditoContribuinteRepository.findCreditos(filtroCreditoContribuinte, pageable);
    }

    public CreditoContribuinteDTO getResumo(Long entidade, Long exercicio, Long credito) {
        CreditoContribuinte creditoContribuinte = (CreditoContribuinte)this.creditoContribuinteRepository.findById((Object)CreditoContribuinteId.of((Long)entidade, (Long)exercicio, (Long)credito)).orElseThrow(() -> new EloValidationException(String.format("Cr\u00e9dito %d n\u00e3o encontrado no exerc\u00edcio %d e entidade %d", credito, exercicio, entidade)));
        CreditoContribuinteDTO creditoContribuinteDTO = CreditoContribuinteDTO.from((CreditoContribuinte)creditoContribuinte);
        creditoContribuinteDTO.getDevolucoes().addAll(this.creditoContribuinteRepository.findDevolucoes(entidade, exercicio, credito));
        return creditoContribuinteDTO;
    }
}

