/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoVinculo;
import br.com.elotech.tributos.domain.Vinculo;
import br.com.elotech.tributos.domain.camposdinamicos.FuncionalidadeCampo;
import br.com.elotech.tributos.dto.CadastroAvulsoDTO;
import br.com.elotech.tributos.dto.CadastroGeralDTO;
import br.com.elotech.tributos.dto.StatusCadastroAvulsoByPessoaDTO;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.VinculoService;
import br.com.elotech.tributos.service.camposdinamicos.RespostaService;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaAndCadastroAvulsoResponseDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaRequestDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CadastroAvulsoService {
    public static final long VINCULO_PRINCIPAL = 1L;
    private final CadastroGeralRepository cadastroGeralRepository;
    private final PessoaService pessoaService;
    private final VinculoService vinculoService;
    private final ParametroGeralService parametroGeralService;
    private final RespostaService respostaService;
    private final CadastroGeralService cadastroGeralService;

    public CadastroAvulsoService(CadastroGeralRepository cadastroGeralRepository, PessoaService pessoaService, VinculoService vinculoService, ParametroGeralService parametroGeralService, RespostaService respostaService, CadastroGeralService cadastroGeralService) {
        this.cadastroGeralRepository = cadastroGeralRepository;
        this.pessoaService = pessoaService;
        this.vinculoService = vinculoService;
        this.parametroGeralService = parametroGeralService;
        this.respostaService = respostaService;
        this.cadastroGeralService = cadastroGeralService;
    }

    private static CadastroGeral from(Pessoa pessoa) {
        CadastroGeral cadastroGeral = new CadastroGeral();
        cadastroGeral.setTipoCadastro(TipoCadastro.AVULSO);
        cadastroGeral.setPessoa(pessoa);
        EnderecoPessoa enderecoPrincipal = pessoa.getEnderecoPrincipal();
        if (Objects.nonNull(enderecoPrincipal)) {
            cadastroGeral.setBairro(enderecoPrincipal.getBairro());
            cadastroGeral.setLogradouro(enderecoPrincipal.getLogradouro());
            cadastroGeral.setComplemento(enderecoPrincipal.getComplemento());
            cadastroGeral.setCidade(enderecoPrincipal.getCidade());
            cadastroGeral.setNumero(enderecoPrincipal.getNumero());
            cadastroGeral.setCep(enderecoPrincipal.getCep());
        }
        return cadastroGeral;
    }

    public IncluirPessoaAndCadastroAvulsoResponseDTO incluirCadastroAvulsoEPessoa(IncluirPessoaRequestDTO incluirPessoaRequestDTO) {
        Pessoa pessoa = this.pessoaService.incluirPessoa(incluirPessoaRequestDTO);
        CadastroGeral cadastroAvulso = this.findByPessoaId(pessoa.getId()).stream().findFirst().orElseGet(() -> this.gerarParaPessoa(pessoa, incluirPessoaRequestDTO));
        return IncluirPessoaAndCadastroAvulsoResponseDTO.of((CadastroGeral)cadastroAvulso);
    }

    public CadastroGeralDTO newCadastroAvulsoByPessoaCnpjCpf(String cnpjCpf) {
        Pessoa pessoa = this.findPessoa(cnpjCpf);
        CadastroGeral cadastroGeral = this.gerarParaPessoa(pessoa, new IncluirPessoaRequestDTO());
        this.cadastroGeralService.indexCadastroGeral(cadastroGeral);
        return cadastroGeral.toCadastroGeralDTO();
    }

    private CadastroGeral gerarParaPessoa(Pessoa pessoa, IncluirPessoaRequestDTO incluirPessoaRequestDTO) {
        Vinculo vinculoPrincipal = new Vinculo();
        vinculoPrincipal.setId(Long.valueOf(1L));
        CadastroGeral cadastroAvulso = CadastroAvulsoService.from((Pessoa)pessoa);
        Proprietario proprietario = new Proprietario();
        proprietario.setPessoa(pessoa);
        proprietario.setPrincipal(Boolean.TRUE);
        proprietario.setPercentual(new BigDecimal("100"));
        proprietario.setVinculo(vinculoPrincipal);
        cadastroAvulso.setOrgaoPublico(incluirPessoaRequestDTO.getOrgaoPublico());
        cadastroAvulso.setVisivelNfse(incluirPessoaRequestDTO.getVisivelNfse());
        cadastroAvulso.getProprietarios().add(proprietario);
        return (CadastroGeral)this.cadastroGeralRepository.save((Object)cadastroAvulso);
    }

    public List<CadastroGeral> findByPessoaId(Long pessoa) {
        return this.cadastroGeralRepository.findByPessoaIdAndTipoCadastroAndExclusaoLogicaFalseOrderByCadastroGeralAsc(pessoa, TipoCadastro.AVULSO);
    }

    public CadastroAvulsoDTO findCadastroAvulso(Long idCadastroAvulso) {
        return this.loadDTO(this.buscaCadastroAvulso(idCadastroAvulso));
    }

    public CadastroGeral buscaCadastroAvulso(Long idCadastroAvulso) {
        return (CadastroGeral)this.cadastroGeralRepository.findById((Object)idCadastroAvulso).orElseThrow(() -> new EloValidationException("Cadastro avulso n\u00e3o encontrado."));
    }

    public Boolean existsByCnpjCpf(String cnpjCpf) {
        return this.cadastroGeralRepository.existsByTipoCadastroAndPessoaCnpjCpfAndExclusaoLogicaFalse(TipoCadastro.AVULSO, cnpjCpf);
    }

    public StatusCadastroAvulsoByPessoaDTO statusCadastroAvulsoByPessoa(String cnpjCpf) {
        Pessoa pessoa = this.findPessoa(cnpjCpf);
        List cadastros = this.findByPessoaId(pessoa.getId()).stream().map(CadastroGeral::getId).collect(Collectors.toList());
        StatusCadastroAvulsoByPessoaDTO status = new StatusCadastroAvulsoByPessoaDTO();
        status.setCadastros(cadastros);
        status.setExisteCadastro(!cadastros.isEmpty());
        status.setPermiteInserirNovo(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.PERMITE_CADASTRO_AVULSO_DUPLICADO).booleanValue());
        return status;
    }

    private Pessoa findPessoa(String cnpjCpf) {
        return Optional.ofNullable(this.pessoaService.findByCnpjCpf(cnpjCpf)).orElseThrow(() -> new RestException(HttpStatus.BAD_REQUEST, String.format("Pessoa n\u00e3o encontrada para o documento %s", cnpjCpf)));
    }

    public CadastroGeral beforeSave(CadastroAvulsoDTO cadastroAvulsoDTO) {
        this.beforeToEntityValidation(cadastroAvulsoDTO);
        CadastroGeral cadastroAvulso = cadastroAvulsoDTO.toEntity();
        Proprietario proprietarioPrincipal = new Proprietario();
        proprietarioPrincipal.setPessoa(cadastroAvulsoDTO.getProprietarioPrincipal());
        proprietarioPrincipal.setPrincipal(Boolean.TRUE);
        proprietarioPrincipal.setVinculo(this.vinculoService.findVinculoByTipoVinculo(TipoVinculo.PRINCIPAL));
        proprietarioPrincipal.setPercentual(BigDecimal.valueOf(100L));
        cadastroAvulso.getProprietarios().add(proprietarioPrincipal);
        return cadastroAvulso;
    }

    public CadastroAvulsoDTO save(CadastroAvulsoDTO cadastroAvulsoDTO) {
        return Optional.of(cadastroAvulsoDTO).map(arg_0 -> this.beforeSave(arg_0)).map(arg_0 -> this.save(arg_0)).map(arg_0 -> this.loadDTO(arg_0)).get();
    }

    public CadastroAvulsoDTO update(Long id, CadastroAvulsoDTO cadastroAvulsoDTO) {
        return Optional.of(cadastroAvulsoDTO).map(arg_0 -> this.beforeSave(arg_0)).map(cadastroAvulsoToSave -> this.merge(id, cadastroAvulsoToSave)).map(arg_0 -> this.save(arg_0)).map(arg_0 -> this.loadDTO(arg_0)).get();
    }

    public CadastroGeral save(CadastroGeral cadastroAvulso) {
        this.respostaService.validaRespostas(cadastroAvulso.getRespostasAvulso(), FuncionalidadeCampo.AVULSO);
        return (CadastroGeral)this.cadastroGeralRepository.save((Object)cadastroAvulso);
    }

    public CadastroAvulsoDTO loadDTO(CadastroGeral cadastroAvulso) {
        CadastroAvulsoDTO retorno = CadastroAvulsoDTO.from((CadastroGeral)cadastroAvulso);
        retorno.setRespostasAvulso(this.respostaService.getRespostasAgrupadas(FuncionalidadeCampo.AVULSO, retorno.getId()));
        return retorno;
    }

    public CadastroGeral merge(Long id, CadastroGeral cadastroAvulsoToMerge) {
        CadastroGeral cadastroAvulsoFound = this.buscaCadastroAvulso(id);
        if (cadastroAvulsoFound.getExclusaoLogica().booleanValue()) {
            throw new EloValidationException("Cadastro avulso est\u00e1 inativo.");
        }
        if (!cadastroAvulsoFound.getId().equals(cadastroAvulsoToMerge.getId())) {
            throw new EloValidationException("Para fazer o merge, os cadastros devem ter o mesmo id.");
        }
        cadastroAvulsoFound.setLogradouro(cadastroAvulsoToMerge.getLogradouro());
        cadastroAvulsoFound.setCep(cadastroAvulsoToMerge.getCep());
        cadastroAvulsoFound.setPessoa(cadastroAvulsoToMerge.getPessoa());
        cadastroAvulsoFound.setNumero(cadastroAvulsoToMerge.getNumero());
        cadastroAvulsoFound.setComplemento(cadastroAvulsoToMerge.getComplemento());
        cadastroAvulsoFound.setBairro(cadastroAvulsoToMerge.getBairro());
        cadastroAvulsoFound.setCidade(cadastroAvulsoToMerge.getCidade());
        cadastroAvulsoFound.setUsuario(cadastroAvulsoToMerge.getUsuario());
        cadastroAvulsoFound.setDataAlteracao(LocalDate.now());
        cadastroAvulsoFound.setVisivelNfse(cadastroAvulsoToMerge.getVisivelNfse());
        cadastroAvulsoFound.setOrgaoPublico(cadastroAvulsoToMerge.getOrgaoPublico());
        cadastroAvulsoFound.setDescontoCondicionado(cadastroAvulsoToMerge.getDescontoCondicionado());
        cadastroAvulsoFound.setSubstituicaoTributariaCadastroGeral(cadastroAvulsoToMerge.getSubstituicaoTributariaCadastroGeral());
        cadastroAvulsoFound.mergeProprietarios(cadastroAvulsoToMerge.getProprietarios());
        cadastroAvulsoFound.addObservacoes(cadastroAvulsoToMerge.getObservacoes());
        cadastroAvulsoFound.mergeRespostaAvulso(cadastroAvulsoToMerge.getRespostasAvulso());
        cadastroAvulsoFound.mergeSaneparMatriculas(cadastroAvulsoToMerge.getSaneparMatriculas());
        return cadastroAvulsoFound;
    }

    private void beforeToEntityValidation(CadastroAvulsoDTO cadastroAvulsoDTO) {
        if (!this.codigoAvulsoSequencial() && Objects.isNull(cadastroAvulsoDTO.getCodigo())) {
            throw new EloValidationException("C\u00f3digo do cadastro \u00e9 obrigat\u00f3rio.");
        }
        if (Objects.isNull(cadastroAvulsoDTO.getProprietarioPrincipal())) {
            throw new EloValidationException("Contribuinte \u00e9 obrigat\u00f3rio.");
        }
        if (Objects.isNull(cadastroAvulsoDTO.getProprietarioPrincipal().getCnpjCpf())) {
            throw new EloValidationException("CPF/CNPJ \u00e9 obrigat\u00f3rio.");
        }
        cadastroAvulsoDTO.getResponsaveis().forEach(proprietario -> {
            if (Objects.isNull(proprietario.getPessoa())) {
                throw new EloValidationException("Respons\u00e1vel \u00e9 obrigat\u00f3rio.");
            }
            if (Objects.isNull(proprietario.getVinculo())) {
                throw new EloValidationException("V\u00ednculo \u00e9 obrigat\u00f3rio.");
            }
        });
    }

    private boolean codigoAvulsoSequencial() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CODIGO_AVULSO_SEQUENCIAL, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    public void delete(Long idCadastroAvulso) {
        this.cadastroGeralRepository.delete((Object)this.buscaCadastroAvulso(idCadastroAvulso));
    }
}

