/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaoelogeo.PessoaElogeoDTO;
import br.com.elotech.tributos.service.PessoaService;
import io.swagger.v3.oas.annotations.Operation;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/pessoa"})
public class PessoaElogeoResource {
    private final PessoaService pessoaService;

    public PessoaElogeoResource(PessoaService pessoaService) {
        this.pessoaService = pessoaService;
    }

    @Operation(summary="Retorna uma lista de pessoas")
    @GetMapping
    public ResponseEntity<Page<PessoaElogeoDTO>> findAll(@ParameterObject Pageable page) {
        Page pessoas = this.pessoaService.findAll(page).map(PessoaElogeoDTO::from);
        return ResponseEntity.ok((Object)pessoas);
    }

    @Operation(summary="Retorna uma pessoa em espec\u00edfico")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<PessoaElogeoDTO> findById(@PathVariable Long id) {
        PessoaElogeoDTO pessoaElogeoDTO = this.pessoaService.findById(id).map(PessoaElogeoDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar a Pessoa com o id '%d'.", id)));
        return ResponseEntity.ok((Object)pessoaElogeoDTO);
    }
}

