/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaoelogeo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaoelogeo.LogradouroElogeoDTO;
import br.com.elotech.tributos.service.LogradouroService;
import io.swagger.v3.oas.annotations.Operation;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/logradouro"})
public class LogradouroElogeoResource {
    public final LogradouroService logradouroService;

    public LogradouroElogeoResource(LogradouroService logradouroService) {
        this.logradouroService = logradouroService;
    }

    @Operation(summary="Retorna uma lista de logradouros")
    @GetMapping
    public ResponseEntity<Page<LogradouroElogeoDTO>> findAllByCidadeEntidadePrincipal(@ParameterObject Pageable page) {
        Page logradouros = this.logradouroService.findAllByCidadeEntidadePrincipal(page).map(LogradouroElogeoDTO::from);
        return ResponseEntity.ok((Object)logradouros);
    }

    @Operation(summary="Retorna um logradouro em espec\u00edfico")
    @GetMapping(value={"/{codigo}"})
    public ResponseEntity<LogradouroElogeoDTO> findByLogradouroAndCidadeEntidadePrincipal(@PathVariable Long codigo) {
        LogradouroElogeoDTO logradouroDTO = this.logradouroService.findByLogradouroAndCidadeEntidadePrincipal(codigo).map(LogradouroElogeoDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Logradouro com o c\u00f3digo '%d'.", codigo)));
        return ResponseEntity.ok((Object)logradouroDTO);
    }
}

