/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.documento.protesto;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessa;
import br.com.elotech.tributos.dto.ProtestoRemessaResumoDTO;
import br.com.elotech.tributos.params.FileProtestosRemessaParams;
import br.com.elotech.tributos.params.TxtRemessaParams;
import br.com.elotech.tributos.service.ProtestoRemessaService;
import br.com.elotech.tributos.service.batch.protesto.ImportacaoRetornoRemessaJobStarter;
import br.com.elotech.tributos.service.documento.DocumentoProtestoService;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/protesto-remessa"})
public class ProtestoRemessaResource
extends CrudResource<ProtestoRemessa, Long> {
    private final ProtestoRemessaService protestoRemessaService;
    private final ImportacaoRetornoRemessaJobStarter importacaoRetornoRemessaJobStarter;
    private final DocumentoProtestoService documentoProtestoService;

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<ProtestoRemessaResumoDTO> getProtestoRemessaResumo(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.protestoRemessaService.getProtestoRemessaResumo(id));
    }

    @GetMapping(value={"/{idProtesto}/download-xml"})
    public ResponseEntity<Void> downloadArquivo(@PathVariable Long idProtesto, HttpServletResponse response) throws IOException {
        this.protestoRemessaService.downloadArquivo(response, idProtesto);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/download-txt/{idArquivo}"})
    public ResponseEntity<String> getUrlDownloadProtestoRemessaArquivoEnv(@PathVariable String idArquivo) {
        return ResponseEntity.ok((Object)this.protestoRemessaService.getUrlArquivoEnvioRemessa(idArquivo));
    }

    @PostMapping(value={"/gerar-arquivo"})
    public ResponseEntity<ProtestoRemessaResumoDTO> createArquivoOnS3(@Valid @RequestBody TxtRemessaParams params) {
        return ResponseEntity.ok((Object)this.protestoRemessaService.createArquivoOnS3(params.getIdProtestoRemessa(), params.getDataEmissao()));
    }

    @DeleteMapping(value={"/{idProtesto}/deletar-arquivo/{idArquivo}"})
    public ResponseEntity<Void> removeArquivoOnS3(@PathVariable Long idProtesto, @PathVariable UUID idArquivo) {
        this.protestoRemessaService.removeArquivoOnS3(idProtesto, idArquivo);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/{id}/importar-arquivo-retorno"})
    public ResponseEntity<Void> importarArquivoRetorno(@RequestParam MultipartFile file, @PathVariable Long id) throws IOException, JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        this.protestoRemessaService.importarArquivoRetorno(file, id);
        this.importacaoRetornoRemessaJobStarter.startJob(id);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/download-file-all-termos-id-s3/{idAllTermosRemessaArquivoS3}"})
    public ResponseEntity<String> downloadFileAllTermosByIdArquivoS3(@PathVariable UUID idAllTermosRemessaArquivoS3) {
        return ResponseEntity.ok((Object)this.documentoProtestoService.getUrlAssinada(idAllTermosRemessaArquivoS3));
    }

    @PostMapping(value={"/download-file-all-termos"})
    public ResponseEntity<String> downloadFileAllTermosByIdRemessa(@Valid @RequestBody FileProtestosRemessaParams params) throws IOException {
        return ResponseEntity.ok((Object)this.documentoProtestoService.downloadFileAllTermosByIdRemessa(params.getIdRemessa(), params.getDataReferencia()));
    }

    @Generated
    public ProtestoRemessaResource(ProtestoRemessaService protestoRemessaService, ImportacaoRetornoRemessaJobStarter importacaoRetornoRemessaJobStarter, DocumentoProtestoService documentoProtestoService) {
        this.protestoRemessaService = protestoRemessaService;
        this.importacaoRetornoRemessaJobStarter = importacaoRetornoRemessaJobStarter;
        this.documentoProtestoService = documentoProtestoService;
    }
}

