/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.contribuicaomelhoria;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.contribuicaomelhoria.MelhoriaImobiliario;
import br.com.elotech.tributos.domain.contribuicaomelhoria.id.MelhoriaImobiliarioId;
import br.com.elotech.tributos.dto.contribuicaomelhoria.MelhoriaCadastroDTO;
import java.io.Serializable;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/melhoria-imobiliario"})
public class MelhoriaImobiliarioResource
extends CrudResource<MelhoriaImobiliario, MelhoriaImobiliarioId> {
    @GetMapping(value={"/dto"})
    public ResponseEntity<Page<MelhoriaCadastroDTO>> findAllMelhoriaCadastroDTO(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page page = Objects.requireNonNull((Page)this.findAll(search, pageable).getBody());
        return ResponseEntity.ok((Object)page.map(MelhoriaCadastroDTO::from));
    }

    @GetMapping(value={"/dto/{entidade}/{exercicio}/{numeroEdital}/{idCadastro}/{tipoCadastro}/{cadastroGeral}"})
    public ResponseEntity<MelhoriaCadastroDTO> findOneMelhoriaCadastroDTO(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="numeroEdital") Long numeroEdital, @PathVariable(value="idCadastro") Long idCadastro, @PathVariable(value="tipoCadastro") Long tipoCadastro, @PathVariable(value="cadastroGeral") Long cadastroGeral) {
        MelhoriaImobiliarioId id = MelhoriaImobiliarioId.from((Long)entidade, (Long)exercicio, (Long)numeroEdital, (Long)idCadastro, (Long)tipoCadastro, (Long)cadastroGeral);
        MelhoriaImobiliario found = Objects.requireNonNull((MelhoriaImobiliario)this.findOne((Serializable)id).getBody());
        return ResponseEntity.ok((Object)MelhoriaCadastroDTO.from((MelhoriaImobiliario)found));
    }

    @PostMapping(value={"/dto"})
    public ResponseEntity<MelhoriaCadastroDTO> save(@RequestBody @Valid MelhoriaCadastroDTO dto, Authentication authentication) {
        MelhoriaImobiliario saved = Objects.requireNonNull((MelhoriaImobiliario)this.save((EloEntity)dto.toEntity(), authentication).getBody());
        return ResponseEntity.ok((Object)MelhoriaCadastroDTO.from((MelhoriaImobiliario)saved));
    }

    @PutMapping(value={"/dto/{entidade}/{exercicio}/{numeroEdital}/{idCadastro}/{tipoCadastro}/{cadastroGeral}"})
    public ResponseEntity<MelhoriaCadastroDTO> update(@RequestBody @Valid MelhoriaCadastroDTO dto, @PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="numeroEdital") Long numeroEdital, @PathVariable(value="idCadastro") Long idCadastro, @PathVariable(value="tipoCadastro") Long tipoCadastro, @PathVariable(value="cadastroGeral") Long cadastroGeral, Authentication authentication) {
        MelhoriaImobiliarioId id = MelhoriaImobiliarioId.from((Long)entidade, (Long)exercicio, (Long)numeroEdital, (Long)idCadastro, (Long)tipoCadastro, (Long)cadastroGeral);
        MelhoriaImobiliario saved = Objects.requireNonNull((MelhoriaImobiliario)this.update((EloEntity)dto.toEntity(), (Serializable)id, authentication).getBody());
        return ResponseEntity.ok((Object)MelhoriaCadastroDTO.from((MelhoriaImobiliario)saved));
    }

    @DeleteMapping(value={"/{entidade}/{exercicio}/{numeroEdital}/{idCadastro}/{tipoCadastro}/{cadastroGeral}"})
    public ResponseEntity<Void> remove(@PathVariable(value="entidade") Long entidade, @PathVariable(value="exercicio") Long exercicio, @PathVariable(value="numeroEdital") Long numeroEdital, @PathVariable(value="idCadastro") Long idCadastro, @PathVariable(value="tipoCadastro") Long tipoCadastro, @PathVariable(value="cadastroGeral") Long cadastroGeral, Authentication authentication) {
        MelhoriaImobiliarioId id = MelhoriaImobiliarioId.from((Long)entidade, (Long)exercicio, (Long)numeroEdital, (Long)idCadastro, (Long)tipoCadastro, (Long)cadastroGeral);
        this.remove((Serializable)id, authentication);
        return ResponseEntity.ok().build();
    }
}

