/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.CampoObrigatorio;
import br.com.elotech.tributos.dto.CampoObrigatorioDTO;
import br.com.elotech.tributos.service.CampoObrigatorioService;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/campos-obrigatorios"})
public class CampoObrigatorioResource
extends CrudResource<CampoObrigatorio, Long> {
    private final CampoObrigatorioService campoObrigatorioService;

    public CampoObrigatorioResource(CampoObrigatorioService campoObrigatorioService) {
        this.campoObrigatorioService = campoObrigatorioService;
    }

    @GetMapping(value={"/tipocadastro/{tipoCadastro}"})
    public ResponseEntity<List<CampoObrigatorioDTO>> search(@PathVariable(value="tipoCadastro") Long tipoCadastro) {
        return ResponseEntity.ok((Object)this.campoObrigatorioService.findCamposByTipoCadastro(tipoCadastro));
    }

    @PatchMapping(value={"/{id}/{obrigatorio}/alterar"})
    public ResponseEntity alterarCampoObrigatorio(@PathVariable Long id, @PathVariable Boolean obrigatorio) {
        this.campoObrigatorioService.updateCampoObrigatorio(id, obrigatorio);
        return ResponseEntity.ok((Object)HttpStatus.OK);
    }
}

