/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.audit.domain.ChangeWithRevision;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.audit.AuditService;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSituacao;
import br.com.elotech.tributos.dto.AdvancedSearchItemDTO;
import br.com.elotech.tributos.dto.CadastroGeralSearchParamsDTO;
import br.com.elotech.tributos.dto.CadastroSearchDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioCopiaDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioEnderecoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioRowDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioUnificacaoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.HistoricoTransmissaoDTO;
import br.com.elotech.tributos.resource.RelatorioResource;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.ImpressaoEspelhoCadastrosService;
import br.com.elotech.tributos.util.DateUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cadastro-imobiliario"})
public class CadastroImobiliarioResource {
    private final CadastroImobiliarioService cadastroImobiliarioService;
    private final RelatorioResource relatorioResource;
    private final ImpressaoEspelhoCadastrosService impressaoEspelhoCadastrosService;
    private final AuditService auditService;

    public CadastroImobiliarioResource(CadastroImobiliarioService cadastroImobiliarioService, RelatorioResource relatorioResource, ImpressaoEspelhoCadastrosService impressaoEspelhoCadastrosService, AuditService auditService) {
        this.cadastroImobiliarioService = cadastroImobiliarioService;
        this.relatorioResource = relatorioResource;
        this.impressaoEspelhoCadastrosService = impressaoEspelhoCadastrosService;
        this.auditService = auditService;
    }

    @GetMapping(path={"/imprimir-espelho"}, params={"cadastroGeral"})
    public void imprimirEspelho(@RequestParam(value="cadastroGeral") Long cadastroGeral, HttpServletResponse response) throws IOException {
        ImprimirRelatorioDTO imprimirRelatorioDTO = this.impressaoEspelhoCadastrosService.buildImpressaoEspelhoDTO(TipoCadastro.IMOBILIARIO, cadastroGeral);
        this.relatorioResource.imprimirRelatorioGenerico(imprimirRelatorioDTO, response);
    }

    @GetMapping(path={"/imprimir-espelho-especifico-completo"}, params={"cadastroGeral"})
    public void imprimirEspelhoEspecificoCompleto(@RequestParam(value="cadastroGeral") Long cadastroGeral, HttpServletResponse response) throws IOException {
        ImprimirRelatorioDTO imprimirRelatorioDTO = this.impressaoEspelhoCadastrosService.buildImpressaoEspelhoEspecificoCompletoDTO(TipoCadastro.IMOBILIARIO, cadastroGeral);
        this.relatorioResource.imprimirRelatorioGenerico(imprimirRelatorioDTO, response);
    }

    @GetMapping(path={"/imprimir-espelho-especifico-resumido"}, params={"cadastroGeral"})
    public void imprimirEspelhoEspecificoResumido(@RequestParam(value="cadastroGeral") Long cadastroGeral, HttpServletResponse response) throws IOException {
        ImprimirRelatorioDTO imprimirRelatorioDTO = this.impressaoEspelhoCadastrosService.buildImpressaoEspelhoEspecificoResumidoDTO(TipoCadastro.IMOBILIARIO, cadastroGeral);
        this.relatorioResource.imprimirRelatorioGenerico(imprimirRelatorioDTO, response);
    }

    @PostMapping(value={"/search"})
    public ResponseEntity<CadastroSearchDTO<CadastroImobiliarioRowDTO>> searchCadastrosImobiliarios(@RequestBody CadastroGeralSearchParamsDTO searchParams, Pageable pageable) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioService.searchCadastrosImobiliarios(searchParams, pageable));
    }

    @PostMapping(value={"/advanced-search"})
    public ResponseEntity<CadastroSearchDTO<CadastroImobiliarioRowDTO>> advancedSearchCadastrosImobiliarios(Pageable pageable, @RequestBody List<AdvancedSearchItemDTO> searchParams) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioService.advancedSearchCadastros(searchParams, pageable));
    }

    @PostMapping
    public ResponseEntity<CadastroImobiliarioDTO> save(@RequestBody CadastroImobiliarioDTO cadastroImobiliarioDTO) {
        return ResponseEntity.created((URI)URI.create("")).body((Object)this.cadastroImobiliarioService.saveDTO(cadastroImobiliarioDTO, Boolean.TRUE));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<CadastroImobiliarioDTO> update(@RequestBody CadastroImobiliarioDTO cadastroImobiliarioDTO) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioService.saveDTO(cadastroImobiliarioDTO, Boolean.FALSE));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<CadastroImobiliarioDTO> findById(@PathVariable Long id) {
        CadastroImobiliario found = (CadastroImobiliario)this.cadastroImobiliarioService.findById((Serializable)id).orElseThrow(() -> new EloValidationException("Cadastro imobili\u00e1rio n\u00e3o encontrado"));
        return ResponseEntity.ok((Object)this.cadastroImobiliarioService.loadDTO(found));
    }

    @GetMapping(value={"/sequence"})
    public ResponseEntity<Long> getSequence() {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioService.validateAndGetCadastroGeralSequence(null));
    }

    @GetMapping(value={"/findall"})
    public ResponseEntity<Page<CadastroImobiliario>> findAll(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page found = this.cadastroImobiliarioService.findByRsql(search, pageable);
        return ResponseEntity.ok((Object)found);
    }

    @GetMapping(value={"/{id}/por-data"})
    public ResponseEntity<CadastroImobiliarioDTO> findByIdAtDate(@PathVariable Long id, @RequestParam(value="referenceDate") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime date) {
        CadastroImobiliario found = (CadastroImobiliario)this.auditService.getRecordAtDate(CadastroImobiliario.class, (Serializable)id, date);
        if (Objects.isNull(found)) {
            throw RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar dados para o cadastro imobili\u00e1rio %d na data %s.", id, DateUtils.localDateTimeToStringFormatoBrasileiro((LocalDateTime)date)));
        }
        return ResponseEntity.ok((Object)CadastroImobiliarioDTO.fromComRespostaAgrupada((CadastroImobiliario)found));
    }

    @GetMapping(value={"/{id}/historico"})
    public ResponseEntity<Page<ChangeWithRevision>> getLog(@PathVariable(value="id") Long id, @RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.auditService.getRevisionForEntity(CadastroImobiliario.class, (Serializable)id, search, pageable));
    }

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<CadastroImobiliarioRowDTO> getResumo(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioService.findById((Serializable)id).map(CadastroImobiliarioRowDTO::from).orElseThrow(() -> RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar o cadastro imobili\u00e1rio com id %d.", id))));
    }

    @GetMapping(value={"/dados-endereco/{cadastroGeralImobiliario}"})
    public ResponseEntity<CadastroImobiliarioEnderecoDTO> getEnderecoByCadastroImobiliario(@PathVariable Long cadastroGeralImobiliario) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioService.getEnderecoByCadastroImobiliario(cadastroGeralImobiliario));
    }

    @GetMapping(value={"/{id}/situacoes"})
    public ResponseEntity<List<CadastroImobiliarioSituacao>> getSituacoes(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioService.getSituacoes(id));
    }

    @GetMapping(value={"/{id}/historico-transmissao"})
    public ResponseEntity<List<HistoricoTransmissaoDTO>> getHistoricoTransmissao(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioService.getHistoricoTransmissoes(id));
    }

    @PostMapping(value={"/{id}/situacoes"})
    public ResponseEntity<List<CadastroImobiliarioSituacao>> createSituacao(@RequestBody CadastroImobiliarioSituacao situacao, @PathVariable Long id) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioService.createSituacao(id, situacao));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteEntityById(@PathVariable Long id) {
        this.cadastroImobiliarioService.deleteById(id);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/{id}/copiar"})
    public ResponseEntity<CadastroImobiliarioDTO> copiar(@PathVariable Long id, @RequestBody CadastroImobiliarioCopiaDTO cadastroCopia) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioService.copiar(id, cadastroCopia));
    }

    @GetMapping(value={"/{idCadastro}/imoveis-para-unificacao"})
    public ResponseEntity<List<CadastroImobiliarioUnificacaoDTO>> findCadastrosAptosUnificacao(@PathVariable Long idCadastro) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioService.findImobiliariosElegiveisUnificacao(idCadastro));
    }
}

