/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.audit.domain.ChangeWithRevision;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.audit.AuditService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.dto.AdvancedSearchItemDTO;
import br.com.elotech.tributos.dto.CadastroAvulsoDTO;
import br.com.elotech.tributos.dto.CadastroAvulsoRowDTO;
import br.com.elotech.tributos.dto.CadastroGeralDTO;
import br.com.elotech.tributos.dto.CadastroGeralSearchParamsDTO;
import br.com.elotech.tributos.dto.CadastroSearchDTO;
import br.com.elotech.tributos.dto.PessoaDTO;
import br.com.elotech.tributos.dto.StatusCadastroAvulsoByPessoaDTO;
import br.com.elotech.tributos.service.CadastroAvulsoService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaAndCadastroAvulsoResponseDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaRequestDTO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cadastros-avulso"})
public class CadastroAvulsoResource {
    private final CadastroAvulsoService cadastroAvulsoService;
    private final CadastroGeralService cadastroGeralService;
    private final AuditService auditService;

    @GetMapping(value={"/{idCadastroAvulso}"})
    public ResponseEntity<CadastroAvulsoDTO> findCadastroAvulso(@PathVariable Long idCadastroAvulso) {
        return ResponseEntity.ok((Object)this.cadastroAvulsoService.findCadastroAvulso(idCadastroAvulso));
    }

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<CadastroAvulsoRowDTO> getResumo(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.cadastroGeralService.findById((Serializable)id).filter(cadastroGeral -> cadastroGeral.getTipoCadastro().isAvulso()).map(CadastroAvulsoRowDTO::from).orElseThrow(() -> RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar o cadastro avulso com id %d.", id))));
    }

    @GetMapping(value={"/{id}/por-data"})
    public ResponseEntity<CadastroAvulsoDTO> findByIdAtDate(@PathVariable Long id, @RequestParam(value="referenceDate") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime date) {
        CadastroGeral found = (CadastroGeral)this.auditService.getRecordAtDate(CadastroGeral.class, (Serializable)id, date);
        if (Objects.isNull(found)) {
            throw RestException.notFound((String)String.format("N\u00e3o foi poss\u00edvel encontrar dados para o cadastro avulso %d na data %s.", id, DateUtils.localDateTimeToStringFormatoBrasileiro((LocalDateTime)date)));
        }
        return ResponseEntity.ok((Object)CadastroAvulsoDTO.fromComRespostaAgrupada((CadastroGeral)found));
    }

    @GetMapping(value={"/{id}/historico"})
    public ResponseEntity<Page<ChangeWithRevision>> getLog(@PathVariable(value="id") Long id, @RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.auditService.getRevisionForEntity(CadastroGeral.class, (Serializable)id, search, pageable));
    }

    @GetMapping(value={"/exists-by-cnpjCpf/{cnpjCpf}"})
    public ResponseEntity<Boolean> existsByCnpjCpf(@PathVariable String cnpjCpf) {
        return ResponseEntity.ok((Object)this.cadastroAvulsoService.existsByCnpjCpf(cnpjCpf));
    }

    @GetMapping(value={"/status/by-pessoa"})
    public ResponseEntity<StatusCadastroAvulsoByPessoaDTO> statusCadastroAvulsoByPessoa(@RequestParam(value="cnpjCpf") String cnpjCpf) {
        return ResponseEntity.ok((Object)this.cadastroAvulsoService.statusCadastroAvulsoByPessoa(cnpjCpf));
    }

    @PostMapping(value={"/search"})
    public ResponseEntity<CadastroSearchDTO> searchCadastrosAvulsos(@RequestBody CadastroGeralSearchParamsDTO searchParams, Pageable pageable) {
        return ResponseEntity.ok((Object)this.cadastroGeralService.searchCadastrosAvulsos(searchParams, pageable));
    }

    @PostMapping(value={"/advanced-search"})
    public ResponseEntity<CadastroSearchDTO> advancedSearchCadastrosAvulsos(@RequestBody List<AdvancedSearchItemDTO> searchParams, Pageable pageable) {
        return ResponseEntity.ok((Object)this.cadastroGeralService.advancedSearchCadastrosAvulsos(searchParams, pageable));
    }

    @PostMapping
    public ResponseEntity<IncluirPessoaAndCadastroAvulsoResponseDTO> incluirCadastroAvulsoEPessoa(@RequestBody PessoaDTO pessoaDTO) {
        return ResponseEntity.ok((Object)this.cadastroAvulsoService.incluirCadastroAvulsoEPessoa(IncluirPessoaRequestDTO.from((PessoaDTO)pessoaDTO)));
    }

    @PostMapping(value={"/by-pessoa/cnpjcpf/{cnpjCpf}"})
    public ResponseEntity<CadastroGeralDTO> incluirCadastroAvulsoByPessoaCnpjCpf(@PathVariable(value="cnpjCpf") String cnpjCpf) {
        return ResponseEntity.ok((Object)this.cadastroAvulsoService.newCadastroAvulsoByPessoaCnpjCpf(cnpjCpf));
    }

    @PostMapping(value={"/save"})
    public ResponseEntity<CadastroAvulsoDTO> save(@Valid @RequestBody CadastroAvulsoDTO cadastroAvulsoDTO) {
        return ResponseEntity.ok((Object)this.cadastroAvulsoService.save(cadastroAvulsoDTO));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<CadastroAvulsoDTO> update(@PathVariable Long id, @Valid @RequestBody CadastroAvulsoDTO cadastroAvulsoDTO) {
        return ResponseEntity.ok((Object)this.cadastroAvulsoService.update(id, cadastroAvulsoDTO));
    }

    @DeleteMapping(value={"/{idCadastroAvulso}"})
    public ResponseEntity<Void> delete(@PathVariable Long idCadastroAvulso) {
        this.cadastroAvulsoService.delete(idCadastroAvulso);
        return ResponseEntity.ok().build();
    }

    @Generated
    public CadastroAvulsoResource(CadastroAvulsoService cadastroAvulsoService, CadastroGeralService cadastroGeralService, AuditService auditService) {
        this.cadastroAvulsoService = cadastroAvulsoService;
        this.cadastroGeralService = cadastroGeralService;
        this.auditService = auditService;
    }
}

