/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.parcelamento.AtualizacaoMonetaria;
import br.com.elotech.tributos.domain.parcelamento.LoteParcelamentoReajuste;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.parcelamento.AtualizacaoMonetariaDTO;
import br.com.elotech.tributos.exception.LoteParcelamentoReajusteNotFoundException;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.AtualizacaoMonetariaService;
import br.com.elotech.tributos.service.BatchService;
import br.com.elotech.tributos.service.LoteParcelamentoReajusteService;
import br.com.elotech.tributos.service.parcelametoreajuste.LoteReajusteParcelamentoJobStarter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/atualizacao-monetaria"})
public class AtualizacaoMonetariaResource
extends CrudResource<AtualizacaoMonetaria, Long> {
    @Autowired
    private AtualizacaoMonetariaService atualizacaoMonetariaService;
    @Autowired
    private LoteParcelamentoReajusteService loteParcelamentoReajusteService;
    @Autowired
    private LoteReajusteParcelamentoJobStarter loteReajusteParcelamentoJobStarter;
    @Autowired
    private BatchService batchService;
    @Autowired
    private ObjectMapper objectMapper;

    @PostMapping(path={"/gerar-atualizacao"})
    public ResponseEntity<Void> generateAtualizacao(@RequestBody AtualizacaoMonetariaDTO atualizacaoMonetariaDTO) {
        this.atualizacaoMonetariaService.generateAtualizacaoMonetaria(atualizacaoMonetariaDTO);
        return ResponseEntity.ok().build();
    }

    @PostMapping(path={"/atualizar/async"})
    public ResponseEntity<Void> atualizaParcelamento(@RequestBody AtualizacaoMonetariaDTO request) {
        UserSecurityDTO user = SecurityUtils.getUserSecurityDTO();
        this.atualizacaoMonetariaService.atualizaMonetariamenteParcelamanto(request, user);
        return ResponseEntity.accepted().build();
    }

    @PostMapping(path={"/atualizar/loteReajuste"})
    public ResponseEntity<Void> reajustarParcelamentoLote(@RequestBody AtualizacaoMonetariaDTO request) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        UserSecurityDTO user = SecurityUtils.getUserSecurityDTO();
        LoteParcelamentoReajuste parcelamentoReajuste = this.loteParcelamentoReajusteService.createLoteParcelamentoReajuste(request, user.getPreferredUsername());
        this.loteReajusteParcelamentoJobStarter.startJob(parcelamentoReajuste);
        return ResponseEntity.accepted().build();
    }

    @PostMapping(value={"/reprocessar-parcelamento/{loteParcelamentoReajusteId}"})
    public ResponseEntity<Void> reprocessarAjusteMonetarioParcelamento(@PathVariable Long loteParcelamentoReajusteId) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        LoteParcelamentoReajuste loteParcelamentoReajuste = (LoteParcelamentoReajuste)this.loteParcelamentoReajusteService.findById((Serializable)loteParcelamentoReajusteId).orElseThrow(() -> new LoteParcelamentoReajusteNotFoundException(loteParcelamentoReajusteId));
        this.loteReajusteParcelamentoJobStarter.startJob(loteParcelamentoReajuste);
        return ResponseEntity.accepted().build();
    }
}

