/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.acrescimo.AtualizacaoDireta;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.acrescimo.AtualizacaoDiretaRequestDTO;
import br.com.elotech.tributos.dto.acrescimo.AtualizacaoDiretaResponseDTO;
import br.com.elotech.tributos.dto.acrescimo.SimulacaoAtualizacaoDiretaDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.AtualizacaoDiretaService;
import java.io.Serializable;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/atualizacao-direta"})
public class AtualizacaoDiretaResource {
    private final AtualizacaoDiretaService atualizacaoDiretaService;

    @GetMapping
    public ResponseEntity<Page<AtualizacaoDiretaResponseDTO>> findAll(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page atualizacaoDireta = this.atualizacaoDiretaService.findByRsql(search, pageable);
        return ResponseEntity.ok((Object)atualizacaoDireta.map(AtualizacaoDiretaResponseDTO::of));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<AtualizacaoDiretaResponseDTO> findById(@PathVariable(value="id") Long id) {
        AtualizacaoDireta atualizacaoDireta = (AtualizacaoDireta)this.atualizacaoDiretaService.findById((Serializable)id).orElseThrow(() -> new EloValidationException("Atualiza\u00e7\u00e3o direta n\u00e3o encontrada"));
        return ResponseEntity.ok((Object)AtualizacaoDiretaResponseDTO.of((AtualizacaoDireta)atualizacaoDireta));
    }

    @Transactional(readOnly=true)
    @PostMapping(value={"/simular"})
    public ResponseEntity<SimulacaoAtualizacaoDiretaDTO> simularAtualizacao(@RequestBody @Valid AtualizacaoDiretaRequestDTO dto) {
        return ResponseEntity.ok((Object)this.atualizacaoDiretaService.simularAtualizacao(dto));
    }

    @PostMapping
    public ResponseEntity<Void> gerarAtualizacaoAsync(@RequestBody @Valid AtualizacaoDiretaRequestDTO dto) {
        UserSecurityDTO user = SecurityUtils.getUserSecurityDTO();
        this.atualizacaoDiretaService.gerarAtualizacaoAsync(dto, user);
        return ResponseEntity.accepted().build();
    }

    @Generated
    public AtualizacaoDiretaResource(AtualizacaoDiretaService atualizacaoDiretaService) {
        this.atualizacaoDiretaService = atualizacaoDiretaService;
    }
}

