/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.AlteracaoVencimentosDTO;
import br.com.elotech.tributos.dto.FiltroAlteracaoVencimentosDTO;
import br.com.elotech.tributos.service.AlteracaoVencimentosService;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/alteracao-vencimentos"})
public class AlteracaoVencimentosResource {
    private final AlteracaoVencimentosService alteracaoVencimentosService;

    public AlteracaoVencimentosResource(AlteracaoVencimentosService alteracaoVencimentosService) {
        this.alteracaoVencimentosService = alteracaoVencimentosService;
    }

    @PostMapping(value={"/search"})
    public ResponseEntity<Page<AlteracaoVencimentosDTO>> findAllDebitosParaAlteracaoVencimentos(@RequestBody @Valid FiltroAlteracaoVencimentosDTO filtro, Pageable page) {
        return ResponseEntity.ok((Object)this.alteracaoVencimentosService.searchVencimentosDTO(filtro, page));
    }

    @PutMapping
    public ResponseEntity<Void> update(@RequestBody FiltroAlteracaoVencimentosDTO filtroAlteracaoVencimentosDTO) {
        this.alteracaoVencimentosService.updateVencimentos(filtroAlteracaoVencimentosDTO);
        return ResponseEntity.ok().build();
    }
}

