/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.InscricaoDividaAtivaDTO;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.InscricaoCreditoDividaAtivaMaDTO;
import br.com.elotech.tributos.repository.simam.InscricaoCreditoDividaAtivaCustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.time.Month;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class InscricaoCreditoDividaAtivaCustomRepositoryImpl
implements InscricaoCreditoDividaAtivaCustomRepository {
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public InscricaoCreditoDividaAtivaCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<InscricaoDividaAtivaDTO> findLancamentos(Long entidade, Long idPessoa, LocalDate dataInicial, LocalDate dataFinal) {
        boolean consideraImplantacaoSaldo = Month.JANUARY.equals(dataInicial.getMonth());
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("idPessoa", (Object)idPessoa);
        parameters.addValue("dataInicial", (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue("dataFinal", (Object)Date.valueOf(dataFinal), 91);
        if (consideraImplantacaoSaldo) {
            parameters.addValue("exercicio", (Object)dataInicial.getYear());
        }
        String filtroBase = "icd.dtinscricao between :dataInicial and :dataFinal ";
        Object filtro = consideraImplantacaoSaldo ? filtroBase + " OR (icd.idtipooperacaocredito = 2 and icd.nranodivida = :exercicio)" : filtroBase;
        String sql = FileUtils.readResourceAsString((String)"sql/simam/inscricaoDividaAtivaLancamentos.sql").replace("$FILTRO", (CharSequence)filtro);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(InscricaoDividaAtivaDTO.class));
    }

    public List<InscricaoCreditoDividaAtivaMaDTO> findLancamentosMa(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("dataInicial", (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue("dataFinal", (Object)Date.valueOf(dataFinal), 91);
        String sql = FileUtils.readResourceAsString((String)"sql/simam/manutencaoarquivo/inscricaoCreditoDividaAtivaMa.sql");
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(InscricaoCreditoDividaAtivaMaDTO.class));
    }
}

