/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.AtendimentoPessoaDTO;
import br.com.elotech.tributos.dto.AtendimentoPessoaDTORowMapper;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ConsultaProprietarioRepository {
    private static final String consultaContribuinteAtendimento = "br/com/elotech/tributos/repository/atendimento/findByContribuinteAtendimento.sql";
    private static final String countConsultaContribuinteAtendimento = "br/com/elotech/tributos/repository/atendimento/countByContribuinteAtendimento.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public Page<AtendimentoPessoaDTO> findPessoas(String searchBuilder, Pageable pageable) {
        String sql = FileUtils.readResourceAsString((String)consultaContribuinteAtendimento);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("search", (Object)searchBuilder, 12);
        Long total = Optional.ofNullable(this.getTotal(parameters)).orElse(0L);
        String sqlComPaginacao = this.getSqlComPaginacao(sql, pageable);
        List pagedRows = this.jdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)parameters, (RowMapper)new AtendimentoPessoaDTORowMapper());
        return new PageImpl(pagedRows, pageable, total.longValue());
    }

    private String getSqlComPaginacao(String sql, Pageable pageable) {
        String finalSort = SqlUtils.getFinalSort((Pageable)pageable);
        return SqlUtils.withPagination((String)sql.concat(finalSort), (Pageable)pageable, (DataSource)this.jdbcTemplate.getJdbcTemplate().getDataSource());
    }

    private Long getTotal(MapSqlParameterSource parameters) {
        String sql = FileUtils.readResourceAsString((String)countConsultaContribuinteAtendimento);
        return (Long)this.jdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
    }

    @Generated
    public ConsultaProprietarioRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

