/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.TipoCadastro;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ConsultaAvisoCadastroRepository {
    private static final String CONSULTA_AVISO_CADASTRO = "br/com/elotech/tributos/repository/consulta-aviso-cadastro.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public ConsultaAvisoCadastroRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Long existsByFiltro(String filtro, TipoCadastro tipoCadastro, Long id) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("tipocadastro", (Object)tipoCadastro.getValue());
        parameters.addValue("id", (Object)id);
        String sqlConsulta = String.format(FileUtils.readResourceAsString((String)CONSULTA_AVISO_CADASTRO), filtro);
        return (Long)this.jdbcTemplate.queryForObject(sqlConsulta, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
    }
}

