/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.hibernatesearch.bridge;

import java.math.BigDecimal;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;

public class BigDecimalToIntegerFieldBridge
implements MetadataProvidingFieldBridge,
TwoWayFieldBridge {
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value != null) {
            BigDecimal decimalValue = (BigDecimal)value;
            Integer indexedValue = decimalValue.intValue();
            luceneOptions.addNumericFieldToDocument(name, (Object)indexedValue, document);
        }
    }

    public Object get(String name, Document document) {
        String fromLucene = document.get(name);
        return new BigDecimal(fromLucene);
    }

    public String objectToString(Object object) {
        return object.toString();
    }

    public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
        builder.field(name, FieldType.INTEGER);
    }
}

