/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.projeto;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.projeto.Projeto;
import br.com.elotech.tributos.domain.projeto.ProjetoDebito;
import br.com.elotech.tributos.dto.projeto.ProjetoDTO;
import br.com.elotech.tributos.dto.projeto.ProjetoDebitoParcelaDTO;
import br.com.elotech.tributos.dto.projeto.ProjetoIsencaoDTO;
import br.com.elotech.tributos.dto.projeto.ProjetoItemDTO;
import br.com.elotech.tributos.dto.projeto.ProjetoObservacaoDTO;
import br.com.elotech.tributos.dto.projeto.ProjetoPessoaDTO;
import br.com.elotech.tributos.dto.projeto.ProjetoResponsavelDTO;
import br.com.elotech.tributos.dto.projeto.ProjetoSubstituidoDTO;
import br.com.elotech.tributos.dto.projeto.SituacaoProjetoDTO;
import br.com.elotech.tributos.dto.projeto.TipoProjetoDTO;
import br.com.elotech.tributos.dto.projeto.TipoVinculoProjetoDTO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProjetoDTO {
    private Long entidade;
    private Long exercicio;
    private Long projeto;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long idCadastro;
    private ProjetoPessoaDTO contribuinte;
    private Long processo;
    private Long exercicioProtocolo;
    private Long tipoProcesso;
    private Long processoIsencao;
    private Long exercicioProtocoloIsencao;
    private Long tipoProcessoIsencao;
    private TipoProjetoDTO tipoProjeto;
    private String art;
    private String rrt;
    private SituacaoProjetoDTO situacao;
    private ProjetoSubstituidoDTO substituido;
    private ProjetoIsencaoDTO isencao;
    private BigDecimal area;
    private TipoVinculoProjetoDTO tipoVinculo;
    private ProjetoPessoaDTO responsavel;
    private String nomeObra;
    private List<ProjetoItemDTO> itens;
    private List<ProjetoResponsavelDTO> responsaveis;
    private List<ProjetoObservacaoDTO> observacoes;
    private List<ProjetoDebitoParcelaDTO> debitos;
    private BigDecimal totalDebitos;
    private String complemento;

    public static ProjetoDTO from(Projeto projeto) {
        return ProjetoDTO.builder().entidade(projeto.getId().getEntidade()).exercicio(projeto.getId().getExercicio()).projeto(projeto.getId().getProjeto()).tipoCadastro((Long)Optional.ofNullable(projeto.getCadastroGeral()).map(CadastroGeral::getTipoCadastro).map(TipoCadastro::getValue).orElse(null)).cadastroGeral((Long)Optional.ofNullable(projeto.getCadastroGeral()).map(CadastroGeral::getCadastroGeral).orElse(null)).idCadastro((Long)Optional.ofNullable(projeto.getCadastroGeral()).map(CadastroGeral::getId).orElse(null)).contribuinte((ProjetoPessoaDTO)Optional.ofNullable(projeto.getPessoa()).map(ProjetoPessoaDTO::from).orElse(null)).processo(projeto.getIdProcesso()).exercicioProtocolo(projeto.getExercicioProtocolo()).tipoProcesso(projeto.getTipoProcesso()).processoIsencao(projeto.getIdProcessoIsencao()).exercicioProtocoloIsencao(projeto.getExercicioProtocoloIsencao()).tipoProcessoIsencao(projeto.getTipoProcessoIsencao()).tipoProjeto((TipoProjetoDTO)Optional.ofNullable(projeto.getTipoProjeto()).map(TipoProjetoDTO::from).orElse(null)).art(projeto.getArt()).rrt(projeto.getRrt()).situacao((SituacaoProjetoDTO)Optional.ofNullable(projeto.getSituacao()).map(SituacaoProjetoDTO::from).orElse(null)).substituido((ProjetoSubstituidoDTO)Optional.ofNullable(projeto.getProjetoSubstituido()).map(ProjetoSubstituidoDTO::from).orElse(null)).isencao((ProjetoIsencaoDTO)Optional.ofNullable(projeto.getIsencao()).map(ProjetoIsencaoDTO::from).orElse(null)).area(projeto.getArea()).tipoVinculo((TipoVinculoProjetoDTO)Optional.ofNullable(projeto.getTipoVinculo()).map(TipoVinculoProjetoDTO::from).orElse(null)).responsavel((ProjetoPessoaDTO)Optional.ofNullable(projeto.getResponsavel()).map(ProjetoPessoaDTO::from).orElse(null)).nomeObra(projeto.getNomeObra()).itens(projeto.getItens().stream().map(ProjetoItemDTO::from).collect(Collectors.toList())).responsaveis(projeto.getResponsaveis().stream().map(ProjetoResponsavelDTO::from).collect(Collectors.toList())).observacoes(projeto.getObservacoes().stream().map(ProjetoObservacaoDTO::from).collect(Collectors.toList())).debitos(projeto.getDebitos().stream().map(ProjetoDebito::getDebito).flatMap(debito -> debito.getParcelas().stream().map(parcela -> ProjetoDebitoParcelaDTO.from((Long)debito.getId(), (DebitoParcela)parcela))).collect(Collectors.toList())).totalDebitos(projeto.getValorTotalDebitos()).complemento(projeto.getComplemento()).build();
    }

    @Generated
    ProjetoDTO(Long entidade, Long exercicio, Long projeto, Long tipoCadastro, Long cadastroGeral, Long idCadastro, ProjetoPessoaDTO contribuinte, Long processo, Long exercicioProtocolo, Long tipoProcesso, Long processoIsencao, Long exercicioProtocoloIsencao, Long tipoProcessoIsencao, TipoProjetoDTO tipoProjeto, String art, String rrt, SituacaoProjetoDTO situacao, ProjetoSubstituidoDTO substituido, ProjetoIsencaoDTO isencao, BigDecimal area, TipoVinculoProjetoDTO tipoVinculo, ProjetoPessoaDTO responsavel, String nomeObra, List<ProjetoItemDTO> itens, List<ProjetoResponsavelDTO> responsaveis, List<ProjetoObservacaoDTO> observacoes, List<ProjetoDebitoParcelaDTO> debitos, BigDecimal totalDebitos, String complemento) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.projeto = projeto;
        this.tipoCadastro = tipoCadastro;
        this.cadastroGeral = cadastroGeral;
        this.idCadastro = idCadastro;
        this.contribuinte = contribuinte;
        this.processo = processo;
        this.exercicioProtocolo = exercicioProtocolo;
        this.tipoProcesso = tipoProcesso;
        this.processoIsencao = processoIsencao;
        this.exercicioProtocoloIsencao = exercicioProtocoloIsencao;
        this.tipoProcessoIsencao = tipoProcessoIsencao;
        this.tipoProjeto = tipoProjeto;
        this.art = art;
        this.rrt = rrt;
        this.situacao = situacao;
        this.substituido = substituido;
        this.isencao = isencao;
        this.area = area;
        this.tipoVinculo = tipoVinculo;
        this.responsavel = responsavel;
        this.nomeObra = nomeObra;
        this.itens = itens;
        this.responsaveis = responsaveis;
        this.observacoes = observacoes;
        this.debitos = debitos;
        this.totalDebitos = totalDebitos;
        this.complemento = complemento;
    }

    @Generated
    public static ProjetoDTOBuilder builder() {
        return new ProjetoDTOBuilder();
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getProjeto() {
        return this.projeto;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getIdCadastro() {
        return this.idCadastro;
    }

    @Generated
    public ProjetoPessoaDTO getContribuinte() {
        return this.contribuinte;
    }

    @Generated
    public Long getProcesso() {
        return this.processo;
    }

    @Generated
    public Long getExercicioProtocolo() {
        return this.exercicioProtocolo;
    }

    @Generated
    public Long getTipoProcesso() {
        return this.tipoProcesso;
    }

    @Generated
    public Long getProcessoIsencao() {
        return this.processoIsencao;
    }

    @Generated
    public Long getExercicioProtocoloIsencao() {
        return this.exercicioProtocoloIsencao;
    }

    @Generated
    public Long getTipoProcessoIsencao() {
        return this.tipoProcessoIsencao;
    }

    @Generated
    public TipoProjetoDTO getTipoProjeto() {
        return this.tipoProjeto;
    }

    @Generated
    public String getArt() {
        return this.art;
    }

    @Generated
    public String getRrt() {
        return this.rrt;
    }

    @Generated
    public SituacaoProjetoDTO getSituacao() {
        return this.situacao;
    }

    @Generated
    public ProjetoSubstituidoDTO getSubstituido() {
        return this.substituido;
    }

    @Generated
    public ProjetoIsencaoDTO getIsencao() {
        return this.isencao;
    }

    @Generated
    public BigDecimal getArea() {
        return this.area;
    }

    @Generated
    public TipoVinculoProjetoDTO getTipoVinculo() {
        return this.tipoVinculo;
    }

    @Generated
    public ProjetoPessoaDTO getResponsavel() {
        return this.responsavel;
    }

    @Generated
    public String getNomeObra() {
        return this.nomeObra;
    }

    @Generated
    public List<ProjetoItemDTO> getItens() {
        return this.itens;
    }

    @Generated
    public List<ProjetoResponsavelDTO> getResponsaveis() {
        return this.responsaveis;
    }

    @Generated
    public List<ProjetoObservacaoDTO> getObservacoes() {
        return this.observacoes;
    }

    @Generated
    public List<ProjetoDebitoParcelaDTO> getDebitos() {
        return this.debitos;
    }

    @Generated
    public BigDecimal getTotalDebitos() {
        return this.totalDebitos;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setProjeto(Long projeto) {
        this.projeto = projeto;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setIdCadastro(Long idCadastro) {
        this.idCadastro = idCadastro;
    }

    @Generated
    public void setContribuinte(ProjetoPessoaDTO contribuinte) {
        this.contribuinte = contribuinte;
    }

    @Generated
    public void setProcesso(Long processo) {
        this.processo = processo;
    }

    @Generated
    public void setExercicioProtocolo(Long exercicioProtocolo) {
        this.exercicioProtocolo = exercicioProtocolo;
    }

    @Generated
    public void setTipoProcesso(Long tipoProcesso) {
        this.tipoProcesso = tipoProcesso;
    }

    @Generated
    public void setProcessoIsencao(Long processoIsencao) {
        this.processoIsencao = processoIsencao;
    }

    @Generated
    public void setExercicioProtocoloIsencao(Long exercicioProtocoloIsencao) {
        this.exercicioProtocoloIsencao = exercicioProtocoloIsencao;
    }

    @Generated
    public void setTipoProcessoIsencao(Long tipoProcessoIsencao) {
        this.tipoProcessoIsencao = tipoProcessoIsencao;
    }

    @Generated
    public void setTipoProjeto(TipoProjetoDTO tipoProjeto) {
        this.tipoProjeto = tipoProjeto;
    }

    @Generated
    public void setArt(String art) {
        this.art = art;
    }

    @Generated
    public void setRrt(String rrt) {
        this.rrt = rrt;
    }

    @Generated
    public void setSituacao(SituacaoProjetoDTO situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setSubstituido(ProjetoSubstituidoDTO substituido) {
        this.substituido = substituido;
    }

    @Generated
    public void setIsencao(ProjetoIsencaoDTO isencao) {
        this.isencao = isencao;
    }

    @Generated
    public void setArea(BigDecimal area) {
        this.area = area;
    }

    @Generated
    public void setTipoVinculo(TipoVinculoProjetoDTO tipoVinculo) {
        this.tipoVinculo = tipoVinculo;
    }

    @Generated
    public void setResponsavel(ProjetoPessoaDTO responsavel) {
        this.responsavel = responsavel;
    }

    @Generated
    public void setNomeObra(String nomeObra) {
        this.nomeObra = nomeObra;
    }

    @Generated
    public void setItens(List<ProjetoItemDTO> itens) {
        this.itens = itens;
    }

    @Generated
    public void setResponsaveis(List<ProjetoResponsavelDTO> responsaveis) {
        this.responsaveis = responsaveis;
    }

    @Generated
    public void setObservacoes(List<ProjetoObservacaoDTO> observacoes) {
        this.observacoes = observacoes;
    }

    @Generated
    public void setDebitos(List<ProjetoDebitoParcelaDTO> debitos) {
        this.debitos = debitos;
    }

    @Generated
    public void setTotalDebitos(BigDecimal totalDebitos) {
        this.totalDebitos = totalDebitos;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjetoDTO)) {
            return false;
        }
        ProjetoDTO other = (ProjetoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$projeto = this.getProjeto();
        Long other$projeto = other.getProjeto();
        if (this$projeto == null ? other$projeto != null : !((Object)this$projeto).equals(other$projeto)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$idCadastro = this.getIdCadastro();
        Long other$idCadastro = other.getIdCadastro();
        if (this$idCadastro == null ? other$idCadastro != null : !((Object)this$idCadastro).equals(other$idCadastro)) {
            return false;
        }
        Long this$processo = this.getProcesso();
        Long other$processo = other.getProcesso();
        if (this$processo == null ? other$processo != null : !((Object)this$processo).equals(other$processo)) {
            return false;
        }
        Long this$exercicioProtocolo = this.getExercicioProtocolo();
        Long other$exercicioProtocolo = other.getExercicioProtocolo();
        if (this$exercicioProtocolo == null ? other$exercicioProtocolo != null : !((Object)this$exercicioProtocolo).equals(other$exercicioProtocolo)) {
            return false;
        }
        Long this$tipoProcesso = this.getTipoProcesso();
        Long other$tipoProcesso = other.getTipoProcesso();
        if (this$tipoProcesso == null ? other$tipoProcesso != null : !((Object)this$tipoProcesso).equals(other$tipoProcesso)) {
            return false;
        }
        Long this$processoIsencao = this.getProcessoIsencao();
        Long other$processoIsencao = other.getProcessoIsencao();
        if (this$processoIsencao == null ? other$processoIsencao != null : !((Object)this$processoIsencao).equals(other$processoIsencao)) {
            return false;
        }
        Long this$exercicioProtocoloIsencao = this.getExercicioProtocoloIsencao();
        Long other$exercicioProtocoloIsencao = other.getExercicioProtocoloIsencao();
        if (this$exercicioProtocoloIsencao == null ? other$exercicioProtocoloIsencao != null : !((Object)this$exercicioProtocoloIsencao).equals(other$exercicioProtocoloIsencao)) {
            return false;
        }
        Long this$tipoProcessoIsencao = this.getTipoProcessoIsencao();
        Long other$tipoProcessoIsencao = other.getTipoProcessoIsencao();
        if (this$tipoProcessoIsencao == null ? other$tipoProcessoIsencao != null : !((Object)this$tipoProcessoIsencao).equals(other$tipoProcessoIsencao)) {
            return false;
        }
        ProjetoPessoaDTO this$contribuinte = this.getContribuinte();
        ProjetoPessoaDTO other$contribuinte = other.getContribuinte();
        if (this$contribuinte == null ? other$contribuinte != null : !this$contribuinte.equals(other$contribuinte)) {
            return false;
        }
        TipoProjetoDTO this$tipoProjeto = this.getTipoProjeto();
        TipoProjetoDTO other$tipoProjeto = other.getTipoProjeto();
        if (this$tipoProjeto == null ? other$tipoProjeto != null : !this$tipoProjeto.equals(other$tipoProjeto)) {
            return false;
        }
        String this$art = this.getArt();
        String other$art = other.getArt();
        if (this$art == null ? other$art != null : !this$art.equals(other$art)) {
            return false;
        }
        String this$rrt = this.getRrt();
        String other$rrt = other.getRrt();
        if (this$rrt == null ? other$rrt != null : !this$rrt.equals(other$rrt)) {
            return false;
        }
        SituacaoProjetoDTO this$situacao = this.getSituacao();
        SituacaoProjetoDTO other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        ProjetoSubstituidoDTO this$substituido = this.getSubstituido();
        ProjetoSubstituidoDTO other$substituido = other.getSubstituido();
        if (this$substituido == null ? other$substituido != null : !this$substituido.equals(other$substituido)) {
            return false;
        }
        ProjetoIsencaoDTO this$isencao = this.getIsencao();
        ProjetoIsencaoDTO other$isencao = other.getIsencao();
        if (this$isencao == null ? other$isencao != null : !this$isencao.equals(other$isencao)) {
            return false;
        }
        BigDecimal this$area = this.getArea();
        BigDecimal other$area = other.getArea();
        if (this$area == null ? other$area != null : !((Object)this$area).equals(other$area)) {
            return false;
        }
        TipoVinculoProjetoDTO this$tipoVinculo = this.getTipoVinculo();
        TipoVinculoProjetoDTO other$tipoVinculo = other.getTipoVinculo();
        if (this$tipoVinculo == null ? other$tipoVinculo != null : !this$tipoVinculo.equals(other$tipoVinculo)) {
            return false;
        }
        ProjetoPessoaDTO this$responsavel = this.getResponsavel();
        ProjetoPessoaDTO other$responsavel = other.getResponsavel();
        if (this$responsavel == null ? other$responsavel != null : !this$responsavel.equals(other$responsavel)) {
            return false;
        }
        String this$nomeObra = this.getNomeObra();
        String other$nomeObra = other.getNomeObra();
        if (this$nomeObra == null ? other$nomeObra != null : !this$nomeObra.equals(other$nomeObra)) {
            return false;
        }
        List this$itens = this.getItens();
        List other$itens = other.getItens();
        if (this$itens == null ? other$itens != null : !((Object)this$itens).equals(other$itens)) {
            return false;
        }
        List this$responsaveis = this.getResponsaveis();
        List other$responsaveis = other.getResponsaveis();
        if (this$responsaveis == null ? other$responsaveis != null : !((Object)this$responsaveis).equals(other$responsaveis)) {
            return false;
        }
        List this$observacoes = this.getObservacoes();
        List other$observacoes = other.getObservacoes();
        if (this$observacoes == null ? other$observacoes != null : !((Object)this$observacoes).equals(other$observacoes)) {
            return false;
        }
        List this$debitos = this.getDebitos();
        List other$debitos = other.getDebitos();
        if (this$debitos == null ? other$debitos != null : !((Object)this$debitos).equals(other$debitos)) {
            return false;
        }
        BigDecimal this$totalDebitos = this.getTotalDebitos();
        BigDecimal other$totalDebitos = other.getTotalDebitos();
        if (this$totalDebitos == null ? other$totalDebitos != null : !((Object)this$totalDebitos).equals(other$totalDebitos)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        return !(this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProjetoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $projeto = this.getProjeto();
        result = result * 59 + ($projeto == null ? 43 : ((Object)$projeto).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $idCadastro = this.getIdCadastro();
        result = result * 59 + ($idCadastro == null ? 43 : ((Object)$idCadastro).hashCode());
        Long $processo = this.getProcesso();
        result = result * 59 + ($processo == null ? 43 : ((Object)$processo).hashCode());
        Long $exercicioProtocolo = this.getExercicioProtocolo();
        result = result * 59 + ($exercicioProtocolo == null ? 43 : ((Object)$exercicioProtocolo).hashCode());
        Long $tipoProcesso = this.getTipoProcesso();
        result = result * 59 + ($tipoProcesso == null ? 43 : ((Object)$tipoProcesso).hashCode());
        Long $processoIsencao = this.getProcessoIsencao();
        result = result * 59 + ($processoIsencao == null ? 43 : ((Object)$processoIsencao).hashCode());
        Long $exercicioProtocoloIsencao = this.getExercicioProtocoloIsencao();
        result = result * 59 + ($exercicioProtocoloIsencao == null ? 43 : ((Object)$exercicioProtocoloIsencao).hashCode());
        Long $tipoProcessoIsencao = this.getTipoProcessoIsencao();
        result = result * 59 + ($tipoProcessoIsencao == null ? 43 : ((Object)$tipoProcessoIsencao).hashCode());
        ProjetoPessoaDTO $contribuinte = this.getContribuinte();
        result = result * 59 + ($contribuinte == null ? 43 : $contribuinte.hashCode());
        TipoProjetoDTO $tipoProjeto = this.getTipoProjeto();
        result = result * 59 + ($tipoProjeto == null ? 43 : $tipoProjeto.hashCode());
        String $art = this.getArt();
        result = result * 59 + ($art == null ? 43 : $art.hashCode());
        String $rrt = this.getRrt();
        result = result * 59 + ($rrt == null ? 43 : $rrt.hashCode());
        SituacaoProjetoDTO $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        ProjetoSubstituidoDTO $substituido = this.getSubstituido();
        result = result * 59 + ($substituido == null ? 43 : $substituido.hashCode());
        ProjetoIsencaoDTO $isencao = this.getIsencao();
        result = result * 59 + ($isencao == null ? 43 : $isencao.hashCode());
        BigDecimal $area = this.getArea();
        result = result * 59 + ($area == null ? 43 : ((Object)$area).hashCode());
        TipoVinculoProjetoDTO $tipoVinculo = this.getTipoVinculo();
        result = result * 59 + ($tipoVinculo == null ? 43 : $tipoVinculo.hashCode());
        ProjetoPessoaDTO $responsavel = this.getResponsavel();
        result = result * 59 + ($responsavel == null ? 43 : $responsavel.hashCode());
        String $nomeObra = this.getNomeObra();
        result = result * 59 + ($nomeObra == null ? 43 : $nomeObra.hashCode());
        List $itens = this.getItens();
        result = result * 59 + ($itens == null ? 43 : ((Object)$itens).hashCode());
        List $responsaveis = this.getResponsaveis();
        result = result * 59 + ($responsaveis == null ? 43 : ((Object)$responsaveis).hashCode());
        List $observacoes = this.getObservacoes();
        result = result * 59 + ($observacoes == null ? 43 : ((Object)$observacoes).hashCode());
        List $debitos = this.getDebitos();
        result = result * 59 + ($debitos == null ? 43 : ((Object)$debitos).hashCode());
        BigDecimal $totalDebitos = this.getTotalDebitos();
        result = result * 59 + ($totalDebitos == null ? 43 : ((Object)$totalDebitos).hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProjetoDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", projeto=" + this.getProjeto() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", idCadastro=" + this.getIdCadastro() + ", contribuinte=" + this.getContribuinte() + ", processo=" + this.getProcesso() + ", exercicioProtocolo=" + this.getExercicioProtocolo() + ", tipoProcesso=" + this.getTipoProcesso() + ", processoIsencao=" + this.getProcessoIsencao() + ", exercicioProtocoloIsencao=" + this.getExercicioProtocoloIsencao() + ", tipoProcessoIsencao=" + this.getTipoProcessoIsencao() + ", tipoProjeto=" + this.getTipoProjeto() + ", art=" + this.getArt() + ", rrt=" + this.getRrt() + ", situacao=" + this.getSituacao() + ", substituido=" + this.getSubstituido() + ", isencao=" + this.getIsencao() + ", area=" + this.getArea() + ", tipoVinculo=" + this.getTipoVinculo() + ", responsavel=" + this.getResponsavel() + ", nomeObra=" + this.getNomeObra() + ", itens=" + this.getItens() + ", responsaveis=" + this.getResponsaveis() + ", observacoes=" + this.getObservacoes() + ", debitos=" + this.getDebitos() + ", totalDebitos=" + this.getTotalDebitos() + ", complemento=" + this.getComplemento() + ")";
    }
}

