/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.camposdinamicos;

import br.com.elotech.tributos.domain.camposdinamicos.GrupoCampo;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.dto.camposdinamicos.RespostaDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class GrupoRespostasDTO {
    private Long id;
    private String descricao;
    private List<Resposta> respostas = new ArrayList();

    @JsonIgnore
    public List<Resposta> getRespostasPreenchidas() {
        return this.respostas.stream().filter(resposta -> Objects.nonNull(resposta.getId()) || StringUtils.isNotBlank((CharSequence)resposta.getValor()) || Objects.nonNull(resposta.getAlternativa())).collect(Collectors.toList());
    }

    public static GrupoRespostasDTO from(GrupoCampo grupoCampo) {
        GrupoRespostasDTO grupoRespostasDTO = new GrupoRespostasDTO();
        grupoRespostasDTO.id = grupoCampo.getId();
        grupoRespostasDTO.descricao = grupoCampo.getDescricao();
        grupoRespostasDTO.respostas = grupoCampo.getCampos().stream().map(campo -> {
            Resposta resposta = new Resposta();
            resposta.setCampo(campo);
            return resposta;
        }).collect(Collectors.toList());
        grupoRespostasDTO.getRespostas().sort(Comparator.comparingLong(value -> value.getCampo().getOrdem()));
        return grupoRespostasDTO;
    }

    public static GrupoRespostasDTO from(GrupoCampo grupoCampo, List<RespostaDTO> respostaDTOS) {
        GrupoRespostasDTO grupoRespostasDTO = new GrupoRespostasDTO();
        grupoRespostasDTO.id = grupoCampo.getId();
        grupoRespostasDTO.descricao = grupoCampo.getDescricao();
        grupoRespostasDTO.respostas = respostaDTOS.stream().map(respostaDTO -> {
            if (Objects.isNull(respostaDTO.getResposta())) {
                Resposta resposta = new Resposta();
                resposta.setCampo(respostaDTO.getCampo());
                return resposta;
            }
            return respostaDTO.getResposta();
        }).collect(Collectors.toList());
        grupoRespostasDTO.getRespostas().sort(Comparator.comparingLong(value -> value.getCampo().getOrdem()));
        return grupoRespostasDTO;
    }

    public static GrupoRespostasDTO fromEntidade(GrupoCampo grupoCampo, List<? extends Resposta> respostas) {
        GrupoRespostasDTO grupoRespostasDTO = new GrupoRespostasDTO();
        grupoRespostasDTO.id = grupoCampo.getId();
        grupoRespostasDTO.descricao = grupoCampo.getDescricao();
        grupoRespostasDTO.respostas = respostas;
        grupoRespostasDTO.getRespostas().sort(Comparator.comparingLong(value -> value.getCampo().getOrdem()));
        return grupoRespostasDTO;
    }

    public static List<GrupoRespostasDTO> agruparRespostasPorGrupoCampo(List<? extends Resposta> respostas) {
        return respostas.stream().collect(Collectors.groupingBy(resposta -> resposta.getCampo().getGrupoCampo())).entrySet().stream().map(entry -> GrupoRespostasDTO.fromEntidade((GrupoCampo)((GrupoCampo)entry.getKey()), (List)((List)entry.getValue()))).collect(Collectors.toList());
    }

    @Generated
    public GrupoRespostasDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public List<Resposta> getRespostas() {
        return this.respostas;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setRespostas(List<Resposta> respostas) {
        this.respostas = respostas;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrupoRespostasDTO)) {
            return false;
        }
        GrupoRespostasDTO other = (GrupoRespostasDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        List this$respostas = this.getRespostas();
        List other$respostas = other.getRespostas();
        return !(this$respostas == null ? other$respostas != null : !((Object)this$respostas).equals(other$respostas));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GrupoRespostasDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        List $respostas = this.getRespostas();
        result = result * 59 + ($respostas == null ? 43 : ((Object)$respostas).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GrupoRespostasDTO(id=" + this.getId() + ", descricao=" + this.getDescricao() + ", respostas=" + this.getRespostas() + ")";
    }
}

