/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.TipoFormaPagamento;
import br.com.elotech.tributos.util.CalculoValoresConstants;
import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;

public class DebitoParcelaTributoCotaUnicaDTO {
    private static final BigDecimal CEM = BigDecimal.valueOf(100L);
    private Long entidade;
    private Long exercicio;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long guiaRecolhimento;
    private String descricaoGuia;
    private Long subdivida;
    private Long idDebito;
    private BigDecimal valor = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorDesconto = BigDecimal.ZERO;
    private BigDecimal valorDescontoJuros = BigDecimal.ZERO;
    private BigDecimal valorDescontoMulta = BigDecimal.ZERO;
    private BigDecimal valorDescontoCorrecao = BigDecimal.ZERO;
    private LocalDate vencimento;
    private Long formaPagamento;
    private String tipoFormaPagamento;
    private String descricaoFormaPagamento;
    private String receita;
    private BigDecimal desconto = BigDecimal.ZERO;
    private BigDecimal descontoJuros = BigDecimal.ZERO;
    private BigDecimal descontoMulta = BigDecimal.ZERO;
    private BigDecimal descontoCorrecao = BigDecimal.ZERO;
    private Long ordemEmissao;
    private Boolean verificaFormaPagtoDiferenciada = Boolean.FALSE;
    private Long idCadastro;
    private String nome;

    public Boolean possuiDesconto() {
        return this.desconto.compareTo(BigDecimal.ZERO) > 0 || this.descontoCorrecao.compareTo(BigDecimal.ZERO) > 0 || this.descontoJuros.compareTo(BigDecimal.ZERO) > 0 || this.descontoMulta.compareTo(BigDecimal.ZERO) > 0;
    }

    private void applyDescontoPrincipal() {
        this.valorDesconto = this.calculaDesconto(this.valor, this.desconto);
    }

    private void applyDescontoJuros() {
        this.valorDescontoJuros = this.calculaDesconto(this.valorJuros, this.descontoJuros);
    }

    private void applyDescontoMulta() {
        this.valorDescontoMulta = this.calculaDesconto(this.valorMulta, this.descontoMulta);
    }

    private void applyDescontoCorrecao() {
        this.valorDescontoCorrecao = this.calculaDesconto(this.valorCorrecao, this.descontoCorrecao);
    }

    public DebitoParcelaTributoCotaUnicaDTO applyDesconto() {
        this.applyDescontoPrincipal();
        this.applyDescontoJuros();
        this.applyDescontoMulta();
        this.applyDescontoCorrecao();
        return this;
    }

    private BigDecimal calculaDesconto(BigDecimal valor, BigDecimal percentualDesconto) {
        if (percentualDesconto.compareTo(BigDecimal.ZERO) > 0) {
            return valor.multiply(percentualDesconto).divide(CEM).setScale((int)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS, 4);
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getValorTotal() {
        return this.valor.add(this.valorJuros).add(this.valorMulta).add(this.valorCorrecao).subtract(this.valorDesconto).subtract(this.valorDescontoJuros).subtract(this.valorDescontoMulta).subtract(this.valorDescontoCorrecao);
    }

    public BigDecimal getValorTotalSemDesconto() {
        return this.valor.add(this.valorJuros).add(this.valorMulta).add(this.valorCorrecao);
    }

    public Boolean isCotaUnica() {
        return TipoFormaPagamento.COTA_UNICA.getValue().equals(this.tipoFormaPagamento);
    }

    @Generated
    public DebitoParcelaTributoCotaUnicaDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getGuiaRecolhimento() {
        return this.guiaRecolhimento;
    }

    @Generated
    public String getDescricaoGuia() {
        return this.descricaoGuia;
    }

    @Generated
    public Long getSubdivida() {
        return this.subdivida;
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorDesconto() {
        return this.valorDesconto;
    }

    @Generated
    public BigDecimal getValorDescontoJuros() {
        return this.valorDescontoJuros;
    }

    @Generated
    public BigDecimal getValorDescontoMulta() {
        return this.valorDescontoMulta;
    }

    @Generated
    public BigDecimal getValorDescontoCorrecao() {
        return this.valorDescontoCorrecao;
    }

    @Generated
    public LocalDate getVencimento() {
        return this.vencimento;
    }

    @Generated
    public Long getFormaPagamento() {
        return this.formaPagamento;
    }

    @Generated
    public String getTipoFormaPagamento() {
        return this.tipoFormaPagamento;
    }

    @Generated
    public String getDescricaoFormaPagamento() {
        return this.descricaoFormaPagamento;
    }

    @Generated
    public String getReceita() {
        return this.receita;
    }

    @Generated
    public BigDecimal getDesconto() {
        return this.desconto;
    }

    @Generated
    public BigDecimal getDescontoJuros() {
        return this.descontoJuros;
    }

    @Generated
    public BigDecimal getDescontoMulta() {
        return this.descontoMulta;
    }

    @Generated
    public BigDecimal getDescontoCorrecao() {
        return this.descontoCorrecao;
    }

    @Generated
    public Long getOrdemEmissao() {
        return this.ordemEmissao;
    }

    @Generated
    public Boolean getVerificaFormaPagtoDiferenciada() {
        return this.verificaFormaPagtoDiferenciada;
    }

    @Generated
    public Long getIdCadastro() {
        return this.idCadastro;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setGuiaRecolhimento(Long guiaRecolhimento) {
        this.guiaRecolhimento = guiaRecolhimento;
    }

    @Generated
    public void setDescricaoGuia(String descricaoGuia) {
        this.descricaoGuia = descricaoGuia;
    }

    @Generated
    public void setSubdivida(Long subdivida) {
        this.subdivida = subdivida;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Generated
    public void setValorDescontoJuros(BigDecimal valorDescontoJuros) {
        this.valorDescontoJuros = valorDescontoJuros;
    }

    @Generated
    public void setValorDescontoMulta(BigDecimal valorDescontoMulta) {
        this.valorDescontoMulta = valorDescontoMulta;
    }

    @Generated
    public void setValorDescontoCorrecao(BigDecimal valorDescontoCorrecao) {
        this.valorDescontoCorrecao = valorDescontoCorrecao;
    }

    @Generated
    public void setVencimento(LocalDate vencimento) {
        this.vencimento = vencimento;
    }

    @Generated
    public void setFormaPagamento(Long formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    @Generated
    public void setTipoFormaPagamento(String tipoFormaPagamento) {
        this.tipoFormaPagamento = tipoFormaPagamento;
    }

    @Generated
    public void setDescricaoFormaPagamento(String descricaoFormaPagamento) {
        this.descricaoFormaPagamento = descricaoFormaPagamento;
    }

    @Generated
    public void setReceita(String receita) {
        this.receita = receita;
    }

    @Generated
    public void setDesconto(BigDecimal desconto) {
        this.desconto = desconto;
    }

    @Generated
    public void setDescontoJuros(BigDecimal descontoJuros) {
        this.descontoJuros = descontoJuros;
    }

    @Generated
    public void setDescontoMulta(BigDecimal descontoMulta) {
        this.descontoMulta = descontoMulta;
    }

    @Generated
    public void setDescontoCorrecao(BigDecimal descontoCorrecao) {
        this.descontoCorrecao = descontoCorrecao;
    }

    @Generated
    public void setOrdemEmissao(Long ordemEmissao) {
        this.ordemEmissao = ordemEmissao;
    }

    @Generated
    public void setVerificaFormaPagtoDiferenciada(Boolean verificaFormaPagtoDiferenciada) {
        this.verificaFormaPagtoDiferenciada = verificaFormaPagtoDiferenciada;
    }

    @Generated
    public void setIdCadastro(Long idCadastro) {
        this.idCadastro = idCadastro;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoParcelaTributoCotaUnicaDTO)) {
            return false;
        }
        DebitoParcelaTributoCotaUnicaDTO other = (DebitoParcelaTributoCotaUnicaDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$guiaRecolhimento = this.getGuiaRecolhimento();
        Long other$guiaRecolhimento = other.getGuiaRecolhimento();
        if (this$guiaRecolhimento == null ? other$guiaRecolhimento != null : !((Object)this$guiaRecolhimento).equals(other$guiaRecolhimento)) {
            return false;
        }
        Long this$subdivida = this.getSubdivida();
        Long other$subdivida = other.getSubdivida();
        if (this$subdivida == null ? other$subdivida != null : !((Object)this$subdivida).equals(other$subdivida)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        Long this$formaPagamento = this.getFormaPagamento();
        Long other$formaPagamento = other.getFormaPagamento();
        if (this$formaPagamento == null ? other$formaPagamento != null : !((Object)this$formaPagamento).equals(other$formaPagamento)) {
            return false;
        }
        Long this$ordemEmissao = this.getOrdemEmissao();
        Long other$ordemEmissao = other.getOrdemEmissao();
        if (this$ordemEmissao == null ? other$ordemEmissao != null : !((Object)this$ordemEmissao).equals(other$ordemEmissao)) {
            return false;
        }
        Boolean this$verificaFormaPagtoDiferenciada = this.getVerificaFormaPagtoDiferenciada();
        Boolean other$verificaFormaPagtoDiferenciada = other.getVerificaFormaPagtoDiferenciada();
        if (this$verificaFormaPagtoDiferenciada == null ? other$verificaFormaPagtoDiferenciada != null : !((Object)this$verificaFormaPagtoDiferenciada).equals(other$verificaFormaPagtoDiferenciada)) {
            return false;
        }
        Long this$idCadastro = this.getIdCadastro();
        Long other$idCadastro = other.getIdCadastro();
        if (this$idCadastro == null ? other$idCadastro != null : !((Object)this$idCadastro).equals(other$idCadastro)) {
            return false;
        }
        String this$descricaoGuia = this.getDescricaoGuia();
        String other$descricaoGuia = other.getDescricaoGuia();
        if (this$descricaoGuia == null ? other$descricaoGuia != null : !this$descricaoGuia.equals(other$descricaoGuia)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$valorJuros = this.getValorJuros();
        BigDecimal other$valorJuros = other.getValorJuros();
        if (this$valorJuros == null ? other$valorJuros != null : !((Object)this$valorJuros).equals(other$valorJuros)) {
            return false;
        }
        BigDecimal this$valorMulta = this.getValorMulta();
        BigDecimal other$valorMulta = other.getValorMulta();
        if (this$valorMulta == null ? other$valorMulta != null : !((Object)this$valorMulta).equals(other$valorMulta)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        BigDecimal this$valorDesconto = this.getValorDesconto();
        BigDecimal other$valorDesconto = other.getValorDesconto();
        if (this$valorDesconto == null ? other$valorDesconto != null : !((Object)this$valorDesconto).equals(other$valorDesconto)) {
            return false;
        }
        BigDecimal this$valorDescontoJuros = this.getValorDescontoJuros();
        BigDecimal other$valorDescontoJuros = other.getValorDescontoJuros();
        if (this$valorDescontoJuros == null ? other$valorDescontoJuros != null : !((Object)this$valorDescontoJuros).equals(other$valorDescontoJuros)) {
            return false;
        }
        BigDecimal this$valorDescontoMulta = this.getValorDescontoMulta();
        BigDecimal other$valorDescontoMulta = other.getValorDescontoMulta();
        if (this$valorDescontoMulta == null ? other$valorDescontoMulta != null : !((Object)this$valorDescontoMulta).equals(other$valorDescontoMulta)) {
            return false;
        }
        BigDecimal this$valorDescontoCorrecao = this.getValorDescontoCorrecao();
        BigDecimal other$valorDescontoCorrecao = other.getValorDescontoCorrecao();
        if (this$valorDescontoCorrecao == null ? other$valorDescontoCorrecao != null : !((Object)this$valorDescontoCorrecao).equals(other$valorDescontoCorrecao)) {
            return false;
        }
        LocalDate this$vencimento = this.getVencimento();
        LocalDate other$vencimento = other.getVencimento();
        if (this$vencimento == null ? other$vencimento != null : !((Object)this$vencimento).equals(other$vencimento)) {
            return false;
        }
        String this$tipoFormaPagamento = this.getTipoFormaPagamento();
        String other$tipoFormaPagamento = other.getTipoFormaPagamento();
        if (this$tipoFormaPagamento == null ? other$tipoFormaPagamento != null : !this$tipoFormaPagamento.equals(other$tipoFormaPagamento)) {
            return false;
        }
        String this$descricaoFormaPagamento = this.getDescricaoFormaPagamento();
        String other$descricaoFormaPagamento = other.getDescricaoFormaPagamento();
        if (this$descricaoFormaPagamento == null ? other$descricaoFormaPagamento != null : !this$descricaoFormaPagamento.equals(other$descricaoFormaPagamento)) {
            return false;
        }
        String this$receita = this.getReceita();
        String other$receita = other.getReceita();
        if (this$receita == null ? other$receita != null : !this$receita.equals(other$receita)) {
            return false;
        }
        BigDecimal this$desconto = this.getDesconto();
        BigDecimal other$desconto = other.getDesconto();
        if (this$desconto == null ? other$desconto != null : !((Object)this$desconto).equals(other$desconto)) {
            return false;
        }
        BigDecimal this$descontoJuros = this.getDescontoJuros();
        BigDecimal other$descontoJuros = other.getDescontoJuros();
        if (this$descontoJuros == null ? other$descontoJuros != null : !((Object)this$descontoJuros).equals(other$descontoJuros)) {
            return false;
        }
        BigDecimal this$descontoMulta = this.getDescontoMulta();
        BigDecimal other$descontoMulta = other.getDescontoMulta();
        if (this$descontoMulta == null ? other$descontoMulta != null : !((Object)this$descontoMulta).equals(other$descontoMulta)) {
            return false;
        }
        BigDecimal this$descontoCorrecao = this.getDescontoCorrecao();
        BigDecimal other$descontoCorrecao = other.getDescontoCorrecao();
        if (this$descontoCorrecao == null ? other$descontoCorrecao != null : !((Object)this$descontoCorrecao).equals(other$descontoCorrecao)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        return !(this$nome == null ? other$nome != null : !this$nome.equals(other$nome));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoParcelaTributoCotaUnicaDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $guiaRecolhimento = this.getGuiaRecolhimento();
        result = result * 59 + ($guiaRecolhimento == null ? 43 : ((Object)$guiaRecolhimento).hashCode());
        Long $subdivida = this.getSubdivida();
        result = result * 59 + ($subdivida == null ? 43 : ((Object)$subdivida).hashCode());
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        Long $formaPagamento = this.getFormaPagamento();
        result = result * 59 + ($formaPagamento == null ? 43 : ((Object)$formaPagamento).hashCode());
        Long $ordemEmissao = this.getOrdemEmissao();
        result = result * 59 + ($ordemEmissao == null ? 43 : ((Object)$ordemEmissao).hashCode());
        Boolean $verificaFormaPagtoDiferenciada = this.getVerificaFormaPagtoDiferenciada();
        result = result * 59 + ($verificaFormaPagtoDiferenciada == null ? 43 : ((Object)$verificaFormaPagtoDiferenciada).hashCode());
        Long $idCadastro = this.getIdCadastro();
        result = result * 59 + ($idCadastro == null ? 43 : ((Object)$idCadastro).hashCode());
        String $descricaoGuia = this.getDescricaoGuia();
        result = result * 59 + ($descricaoGuia == null ? 43 : $descricaoGuia.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $valorJuros = this.getValorJuros();
        result = result * 59 + ($valorJuros == null ? 43 : ((Object)$valorJuros).hashCode());
        BigDecimal $valorMulta = this.getValorMulta();
        result = result * 59 + ($valorMulta == null ? 43 : ((Object)$valorMulta).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        BigDecimal $valorDesconto = this.getValorDesconto();
        result = result * 59 + ($valorDesconto == null ? 43 : ((Object)$valorDesconto).hashCode());
        BigDecimal $valorDescontoJuros = this.getValorDescontoJuros();
        result = result * 59 + ($valorDescontoJuros == null ? 43 : ((Object)$valorDescontoJuros).hashCode());
        BigDecimal $valorDescontoMulta = this.getValorDescontoMulta();
        result = result * 59 + ($valorDescontoMulta == null ? 43 : ((Object)$valorDescontoMulta).hashCode());
        BigDecimal $valorDescontoCorrecao = this.getValorDescontoCorrecao();
        result = result * 59 + ($valorDescontoCorrecao == null ? 43 : ((Object)$valorDescontoCorrecao).hashCode());
        LocalDate $vencimento = this.getVencimento();
        result = result * 59 + ($vencimento == null ? 43 : ((Object)$vencimento).hashCode());
        String $tipoFormaPagamento = this.getTipoFormaPagamento();
        result = result * 59 + ($tipoFormaPagamento == null ? 43 : $tipoFormaPagamento.hashCode());
        String $descricaoFormaPagamento = this.getDescricaoFormaPagamento();
        result = result * 59 + ($descricaoFormaPagamento == null ? 43 : $descricaoFormaPagamento.hashCode());
        String $receita = this.getReceita();
        result = result * 59 + ($receita == null ? 43 : $receita.hashCode());
        BigDecimal $desconto = this.getDesconto();
        result = result * 59 + ($desconto == null ? 43 : ((Object)$desconto).hashCode());
        BigDecimal $descontoJuros = this.getDescontoJuros();
        result = result * 59 + ($descontoJuros == null ? 43 : ((Object)$descontoJuros).hashCode());
        BigDecimal $descontoMulta = this.getDescontoMulta();
        result = result * 59 + ($descontoMulta == null ? 43 : ((Object)$descontoMulta).hashCode());
        BigDecimal $descontoCorrecao = this.getDescontoCorrecao();
        result = result * 59 + ($descontoCorrecao == null ? 43 : ((Object)$descontoCorrecao).hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DebitoParcelaTributoCotaUnicaDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", guiaRecolhimento=" + this.getGuiaRecolhimento() + ", descricaoGuia=" + this.getDescricaoGuia() + ", subdivida=" + this.getSubdivida() + ", idDebito=" + this.getIdDebito() + ", valor=" + this.getValor() + ", valorJuros=" + this.getValorJuros() + ", valorMulta=" + this.getValorMulta() + ", valorCorrecao=" + this.getValorCorrecao() + ", valorDesconto=" + this.getValorDesconto() + ", valorDescontoJuros=" + this.getValorDescontoJuros() + ", valorDescontoMulta=" + this.getValorDescontoMulta() + ", valorDescontoCorrecao=" + this.getValorDescontoCorrecao() + ", vencimento=" + this.getVencimento() + ", formaPagamento=" + this.getFormaPagamento() + ", tipoFormaPagamento=" + this.getTipoFormaPagamento() + ", descricaoFormaPagamento=" + this.getDescricaoFormaPagamento() + ", receita=" + this.getReceita() + ", desconto=" + this.getDesconto() + ", descontoJuros=" + this.getDescontoJuros() + ", descontoMulta=" + this.getDescontoMulta() + ", descontoCorrecao=" + this.getDescontoCorrecao() + ", ordemEmissao=" + this.getOrdemEmissao() + ", verificaFormaPagtoDiferenciada=" + this.getVerificaFormaPagtoDiferenciada() + ", idCadastro=" + this.getIdCadastro() + ", nome=" + this.getNome() + ")";
    }
}

