/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.inscricaocadastral;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.inscricaocadastral.ConfiguracaoInscricaoCadastralItem;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="tribconfiginscricaocadastral")
public class ConfiguracaoInscricaoCadastral
implements EloEntity<Long> {
    @Id
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="descricao", column=@Column(name="QUADRICULADESCRICAO")), @AttributeOverride(name="tamanho", column=@Column(name="QUADRICULATAMANHO")), @AttributeOverride(name="ativo", column=@Column(name="QUADRICULAATIVO"))})
    private ConfiguracaoInscricaoCadastralItem quadricula;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="descricao", column=@Column(name="DISTRITODESCRICAO")), @AttributeOverride(name="tamanho", column=@Column(name="DISTRITOTAMANHO")), @AttributeOverride(name="ativo", column=@Column(name="DISTRITOATIVO"))})
    private ConfiguracaoInscricaoCadastralItem distrito;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="descricao", column=@Column(name="SETORDESCRICAO")), @AttributeOverride(name="tamanho", column=@Column(name="SETORTAMANHO")), @AttributeOverride(name="ativo", column=@Column(name="SETORATIVO"))})
    private ConfiguracaoInscricaoCadastralItem setor;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="descricao", column=@Column(name="QUADRADESCRICAO")), @AttributeOverride(name="tamanho", column=@Column(name="QUADRATAMANHO")), @AttributeOverride(name="ativo", column=@Column(name="QUADRAATIVO"))})
    private ConfiguracaoInscricaoCadastralItem quadra;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="descricao", column=@Column(name="LOTEDESCRICAO")), @AttributeOverride(name="tamanho", column=@Column(name="LOTETAMANHO")), @AttributeOverride(name="ativo", column=@Column(name="LOTEATIVO"))})
    private ConfiguracaoInscricaoCadastralItem lote;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="descricao", column=@Column(name="UNIDADEDESCRICAO")), @AttributeOverride(name="tamanho", column=@Column(name="UNIDADETAMANHO")), @AttributeOverride(name="ativo", column=@Column(name="UNIDADEATIVO"))})
    private ConfiguracaoInscricaoCadastralItem unidade;
    private String caractereSeparador;

    public String formatarInscricaoCadastral(String campoQuadricula, String campoDistrito, String campoSetor, String campoQuadra, String campoLote, String campoUnidade) {
        ArrayList<String> inscricaoCadastral = new ArrayList<String>();
        inscricaoCadastral.add(this.formatarCampo(this.quadricula, campoQuadricula));
        inscricaoCadastral.add(this.formatarCampo(this.distrito, campoDistrito));
        inscricaoCadastral.add(this.formatarCampo(this.setor, campoSetor));
        inscricaoCadastral.add(this.formatarCampo(this.quadra, campoQuadra));
        inscricaoCadastral.add(this.formatarCampo(this.lote, campoLote));
        inscricaoCadastral.add(this.formatarCampo(this.unidade, campoUnidade));
        return inscricaoCadastral.stream().filter(Objects::nonNull).collect(Collectors.joining(this.caractereSeparador));
    }

    private String formatarCampo(ConfiguracaoInscricaoCadastralItem configuracaoCampo, String campo) {
        if (Objects.nonNull(configuracaoCampo) && configuracaoCampo.getAtivo().booleanValue()) {
            return configuracaoCampo.formatarValor(campo);
        }
        return null;
    }

    public void validaConfiguracao() {
        if (Stream.of(this.quadricula, this.distrito, this.setor, this.quadra, this.lote, this.unidade).noneMatch(ConfiguracaoInscricaoCadastralItem::getAtivo)) {
            throw new EloValidationException("Configura\u00e7\u00e3o de Inscri\u00e7\u00e3o Cadastral Inv\u00e1lida. Deve existir ao menos um campo ATIVO.");
        }
    }

    @Generated
    public ConfiguracaoInscricaoCadastral() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public ConfiguracaoInscricaoCadastralItem getQuadricula() {
        return this.quadricula;
    }

    @Generated
    public ConfiguracaoInscricaoCadastralItem getDistrito() {
        return this.distrito;
    }

    @Generated
    public ConfiguracaoInscricaoCadastralItem getSetor() {
        return this.setor;
    }

    @Generated
    public ConfiguracaoInscricaoCadastralItem getQuadra() {
        return this.quadra;
    }

    @Generated
    public ConfiguracaoInscricaoCadastralItem getLote() {
        return this.lote;
    }

    @Generated
    public ConfiguracaoInscricaoCadastralItem getUnidade() {
        return this.unidade;
    }

    @Generated
    public String getCaractereSeparador() {
        return this.caractereSeparador;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setQuadricula(ConfiguracaoInscricaoCadastralItem quadricula) {
        this.quadricula = quadricula;
    }

    @Generated
    public void setDistrito(ConfiguracaoInscricaoCadastralItem distrito) {
        this.distrito = distrito;
    }

    @Generated
    public void setSetor(ConfiguracaoInscricaoCadastralItem setor) {
        this.setor = setor;
    }

    @Generated
    public void setQuadra(ConfiguracaoInscricaoCadastralItem quadra) {
        this.quadra = quadra;
    }

    @Generated
    public void setLote(ConfiguracaoInscricaoCadastralItem lote) {
        this.lote = lote;
    }

    @Generated
    public void setUnidade(ConfiguracaoInscricaoCadastralItem unidade) {
        this.unidade = unidade;
    }

    @Generated
    public void setCaractereSeparador(String caractereSeparador) {
        this.caractereSeparador = caractereSeparador;
    }

    @Generated
    public String toString() {
        return "ConfiguracaoInscricaoCadastral(id=" + this.getId() + ", quadricula=" + this.getQuadricula() + ", distrito=" + this.getDistrito() + ", setor=" + this.getSetor() + ", quadra=" + this.getQuadra() + ", lote=" + this.getLote() + ", unidade=" + this.getUnidade() + ", caractereSeparador=" + this.getCaractereSeparador() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfiguracaoInscricaoCadastral)) {
            return false;
        }
        ConfiguracaoInscricaoCadastral other = (ConfiguracaoInscricaoCadastral)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfiguracaoInscricaoCadastral;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

