/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.PagamentoBoleto;
import br.com.elotech.tributos.domain.PagamentoDebito;
import br.com.elotech.tributos.domain.PagamentoId;
import br.com.elotech.tributos.domain.VinculoCreditoPagamento;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBPAGAMENTO")
public class Pagamento
implements EloEntity<PagamentoId> {
    @Caption(value="Id")
    @EmbeddedId
    private PagamentoId id;
    @ManyToOne
    @JsonIgnore
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="exercicioLote", referencedColumnName="exercicio")), @JoinColumnOrFormula(column=@JoinColumn(name="lote", referencedColumnName="lote"))})
    private PagamentoLote lote;
    @OneToOne(mappedBy="pagamento", cascade={CascadeType.ALL})
    private PagamentoBoleto pagamentoBoleto;
    @ManyToOne(fetch=FetchType.LAZY)
    @JsonIgnore
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="contabancaria", referencedColumnName="contabancaria"))})
    private ContaBancaria contaBancaria;
    @Column(name="dataLancamento")
    private LocalDate dataMovimento;
    @NotNull(message="Data pagamento \u00e9 obrigat\u00f3rio no Pagamento")
    private @NotNull(message="Data pagamento \u00e9 obrigat\u00f3rio no Pagamento") LocalDate dataPagamento;
    private LocalDate dataCredito;
    private String usuario;
    private Long lotePref;
    private Long sequenciaPref;
    private String ocorrencia;
    private Boolean simplesNacional = Boolean.FALSE;
    private BigDecimal valorPago = BigDecimal.ZERO;
    @Length(max=30)
    private @Length(max=30) String tipoConversaoPagto;
    private Boolean naoAlteraSituacao;
    @ManyToOne
    @JsonIgnore
    @JoinColumn(name="banco")
    private Banco banco;
    private LocalDate dataBaixa;
    private Long parcelaAnterior;
    private Long mesReferencia;
    private Long anoReferencia;
    private Boolean converte;
    @Column(name="sequenciaarquivo")
    private Long sequenciaLote;
    private Long numeroProcesso;
    private Long anoProcesso;
    private Boolean pagoAMenor = Boolean.FALSE;
    private BigDecimal valorPagoAMaior = BigDecimal.ZERO;
    @OneToMany(mappedBy="pagamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<VinculoCreditoPagamento> creditos = new ArrayList();

    @JsonIgnore
    public Boolean isEstornado() {
        return this.getPagamentoBoleto().getPagamentosDebito().stream().anyMatch(PagamentoDebito::getEstorno);
    }

    @Generated
    public Pagamento() {
    }

    @Generated
    public PagamentoId getId() {
        return this.id;
    }

    @Generated
    public PagamentoLote getLote() {
        return this.lote;
    }

    @Generated
    public PagamentoBoleto getPagamentoBoleto() {
        return this.pagamentoBoleto;
    }

    @Generated
    public ContaBancaria getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public LocalDate getDataMovimento() {
        return this.dataMovimento;
    }

    @Generated
    public LocalDate getDataPagamento() {
        return this.dataPagamento;
    }

    @Generated
    public LocalDate getDataCredito() {
        return this.dataCredito;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Long getLotePref() {
        return this.lotePref;
    }

    @Generated
    public Long getSequenciaPref() {
        return this.sequenciaPref;
    }

    @Generated
    public String getOcorrencia() {
        return this.ocorrencia;
    }

    @Generated
    public Boolean getSimplesNacional() {
        return this.simplesNacional;
    }

    @Generated
    public BigDecimal getValorPago() {
        return this.valorPago;
    }

    @Generated
    public String getTipoConversaoPagto() {
        return this.tipoConversaoPagto;
    }

    @Generated
    public Boolean getNaoAlteraSituacao() {
        return this.naoAlteraSituacao;
    }

    @Generated
    public Banco getBanco() {
        return this.banco;
    }

    @Generated
    public LocalDate getDataBaixa() {
        return this.dataBaixa;
    }

    @Generated
    public Long getParcelaAnterior() {
        return this.parcelaAnterior;
    }

    @Generated
    public Long getMesReferencia() {
        return this.mesReferencia;
    }

    @Generated
    public Long getAnoReferencia() {
        return this.anoReferencia;
    }

    @Generated
    public Boolean getConverte() {
        return this.converte;
    }

    @Generated
    public Long getSequenciaLote() {
        return this.sequenciaLote;
    }

    @Generated
    public Long getNumeroProcesso() {
        return this.numeroProcesso;
    }

    @Generated
    public Long getAnoProcesso() {
        return this.anoProcesso;
    }

    @Generated
    public Boolean getPagoAMenor() {
        return this.pagoAMenor;
    }

    @Generated
    public BigDecimal getValorPagoAMaior() {
        return this.valorPagoAMaior;
    }

    @Generated
    public List<VinculoCreditoPagamento> getCreditos() {
        return this.creditos;
    }

    @Generated
    public void setId(PagamentoId id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setLote(PagamentoLote lote) {
        this.lote = lote;
    }

    @Generated
    public void setPagamentoBoleto(PagamentoBoleto pagamentoBoleto) {
        this.pagamentoBoleto = pagamentoBoleto;
    }

    @JsonIgnore
    @Generated
    public void setContaBancaria(ContaBancaria contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setDataMovimento(LocalDate dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @Generated
    public void setDataPagamento(LocalDate dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Generated
    public void setDataCredito(LocalDate dataCredito) {
        this.dataCredito = dataCredito;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setLotePref(Long lotePref) {
        this.lotePref = lotePref;
    }

    @Generated
    public void setSequenciaPref(Long sequenciaPref) {
        this.sequenciaPref = sequenciaPref;
    }

    @Generated
    public void setOcorrencia(String ocorrencia) {
        this.ocorrencia = ocorrencia;
    }

    @Generated
    public void setSimplesNacional(Boolean simplesNacional) {
        this.simplesNacional = simplesNacional;
    }

    @Generated
    public void setValorPago(BigDecimal valorPago) {
        this.valorPago = valorPago;
    }

    @Generated
    public void setTipoConversaoPagto(String tipoConversaoPagto) {
        this.tipoConversaoPagto = tipoConversaoPagto;
    }

    @Generated
    public void setNaoAlteraSituacao(Boolean naoAlteraSituacao) {
        this.naoAlteraSituacao = naoAlteraSituacao;
    }

    @JsonIgnore
    @Generated
    public void setBanco(Banco banco) {
        this.banco = banco;
    }

    @Generated
    public void setDataBaixa(LocalDate dataBaixa) {
        this.dataBaixa = dataBaixa;
    }

    @Generated
    public void setParcelaAnterior(Long parcelaAnterior) {
        this.parcelaAnterior = parcelaAnterior;
    }

    @Generated
    public void setMesReferencia(Long mesReferencia) {
        this.mesReferencia = mesReferencia;
    }

    @Generated
    public void setAnoReferencia(Long anoReferencia) {
        this.anoReferencia = anoReferencia;
    }

    @Generated
    public void setConverte(Boolean converte) {
        this.converte = converte;
    }

    @Generated
    public void setSequenciaLote(Long sequenciaLote) {
        this.sequenciaLote = sequenciaLote;
    }

    @Generated
    public void setNumeroProcesso(Long numeroProcesso) {
        this.numeroProcesso = numeroProcesso;
    }

    @Generated
    public void setAnoProcesso(Long anoProcesso) {
        this.anoProcesso = anoProcesso;
    }

    @Generated
    public void setPagoAMenor(Boolean pagoAMenor) {
        this.pagoAMenor = pagoAMenor;
    }

    @Generated
    public void setValorPagoAMaior(BigDecimal valorPagoAMaior) {
        this.valorPagoAMaior = valorPagoAMaior;
    }

    @Generated
    public void setCreditos(List<VinculoCreditoPagamento> creditos) {
        this.creditos = creditos;
    }

    @Generated
    public String toString() {
        return "Pagamento(id=" + this.getId() + ", lote=" + this.getLote() + ", pagamentoBoleto=" + this.getPagamentoBoleto() + ", contaBancaria=" + this.getContaBancaria() + ", dataMovimento=" + this.getDataMovimento() + ", dataPagamento=" + this.getDataPagamento() + ", dataCredito=" + this.getDataCredito() + ", usuario=" + this.getUsuario() + ", lotePref=" + this.getLotePref() + ", sequenciaPref=" + this.getSequenciaPref() + ", ocorrencia=" + this.getOcorrencia() + ", simplesNacional=" + this.getSimplesNacional() + ", valorPago=" + this.getValorPago() + ", tipoConversaoPagto=" + this.getTipoConversaoPagto() + ", naoAlteraSituacao=" + this.getNaoAlteraSituacao() + ", banco=" + this.getBanco() + ", dataBaixa=" + this.getDataBaixa() + ", parcelaAnterior=" + this.getParcelaAnterior() + ", mesReferencia=" + this.getMesReferencia() + ", anoReferencia=" + this.getAnoReferencia() + ", converte=" + this.getConverte() + ", sequenciaLote=" + this.getSequenciaLote() + ", numeroProcesso=" + this.getNumeroProcesso() + ", anoProcesso=" + this.getAnoProcesso() + ", pagoAMenor=" + this.getPagoAMenor() + ", valorPagoAMaior=" + this.getValorPagoAMaior() + ", creditos=" + this.getCreditos() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pagamento)) {
            return false;
        }
        Pagamento other = (Pagamento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PagamentoId this$id = this.getId();
        PagamentoId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Pagamento;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PagamentoId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

