/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.caelum.stella.boleto.Banco;
import br.com.caelum.stella.boleto.Beneficiario;
import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.Datas;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import java.time.LocalDate;
import org.apache.commons.lang3.StringUtils;

public interface NossoNumero {
    default public String getFatorVencimento(LocalDate dataEmissao, LocalDate dataVencimento) {
        Datas datas = Datas.novasDatas().comDocumento(dataEmissao.getDayOfMonth(), dataEmissao.getMonthValue(), dataEmissao.getYear()).comProcessamento(dataEmissao.getDayOfMonth(), dataEmissao.getMonthValue(), dataEmissao.getYear()).comVencimento(dataVencimento.getDayOfMonth(), dataVencimento.getMonthValue(), dataVencimento.getYear());
        return Boleto.novoBoleto().comDatas(datas).getFatorVencimento();
    }

    public CodigoBarrasDTO gerar(Bloqueto var1);

    default public Datas getDatasParaGeracaoBoleto(Bloqueto boleto) {
        return Datas.novasDatas().comDocumento(boleto.getDataEmissao().getDayOfMonth(), boleto.getDataEmissao().getMonthValue(), boleto.getDataEmissao().getYear()).comProcessamento(boleto.getDataEmissao().getDayOfMonth(), boleto.getDataEmissao().getMonthValue(), boleto.getDataEmissao().getYear()).comVencimento(boleto.getDataVencimento().getDayOfMonth(), boleto.getDataVencimento().getMonthValue(), boleto.getDataVencimento().getYear());
    }

    default public Boleto getNovoBoleto(Bloqueto boleto, Banco banco, String nossoNumero) {
        return Boleto.novoBoleto().comBanco(banco).comDatas(this.getDatasParaGeracaoBoleto(boleto)).comBeneficiario(this.getBeneficiario(boleto, nossoNumero)).comValorBoleto(boleto.calculaValorBoleto()).comNumeroDoDocumento(boleto.getBloqueto().toString());
    }

    default public Beneficiario getBeneficiario(Bloqueto boleto, String nossoNumero) {
        return Beneficiario.novoBeneficiario().comNumeroConvenio(boleto.getModeloBloqueto().getConvenio().getNumeroConvenio()).comCarteira(boleto.getModeloBloqueto().getConvenio().getCarteira()).comNossoNumero(nossoNumero).comCodigoBeneficiario(StringUtils.leftPad((String)boleto.getModeloBloqueto().getConvenio().getContaBancaria().getConta(), (int)8, (String)"0"));
    }
}

