/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.config;

import br.com.elotech.core.common.license.rest.LicenseClientRest;
import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.core.common.service.ValidaRegistroService;
import br.com.elotech.tributos.config.RegisterConfiguration;
import br.com.elotech.tributos.dto.converter.RegistroDTOConverter;
import br.com.elotech.tributos.repository.RegistroDomainRepository;
import br.com.elotech.tributos.service.impl.ValidaRegistroServiceImpl;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RegisterConfiguration {
    @Bean
    @ConditionalOnProperty(name={"elotech.portal-contribuinte.valida-registro"}, havingValue="false")
    public ValidaRegistroService validaRegistroServiceDev() {
        return new ValidaRegistroServiceStub();
    }

    @Bean
    @ConditionalOnProperty(name={"elotech.portal-contribuinte.valida-registro"}, havingValue="true", matchIfMissing=true)
    public ValidaRegistroService validaRegistroService(EntidadeService entidadeService, RegistroDomainRepository registroRepository, LicenseClientRest licenseClientRest, RegistroDTOConverter registroDTOConverter, @Value(value="${elotech.licenca.url:}") String urlBlueMix) {
        return new ValidaRegistroServiceImpl(entidadeService, registroRepository, licenseClientRest, registroDTOConverter, urlBlueMix);
    }
}

