/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.calculo.domain.TipoCampoDinamico;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.dto.CadastroIsencaoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroRuralCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CampoDinamicoScriptDTO;
import br.com.elotech.tributos.calculo.dto.RespostaDTO;
import br.com.elotech.tributos.calculo.repository.CadastroCalculoRepositoryUtils;
import br.com.elotech.tributos.calculo.repository.CadastroRuralCalculoDTORowMapper;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CadastroRuralCalculoRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CadastroRuralCalculoRepository.class);
    private static final String CADASTRO_RURAL = "br/com/elotech/tributos/calculo/repository/load-cadastro-rural.sql";
    private static final String BOLETIM_RURAL = "br/com/elotech/tributos/calculo/repository/load-cadastro-rural-boletim.sql";
    private static final String CADASTRO_ISENCOES = "br/com/elotech/tributos/calculo/repository/load-cadastro-isencao.sql";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public CadastroRuralCalculoRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<CadastroCalculoRoot> loadCadastros(String filtro, Long exercicio, Set<CampoDinamicoScriptDTO> camposDinamicos) {
        List cadastros = this.loadCadatros(filtro, exercicio);
        Map boletins = this.loadBoletim(filtro, camposDinamicos);
        Map isencoes = this.loadIsencoes(filtro, exercicio);
        return cadastros.stream().collect(Collectors.groupingBy(CadastroCalculoDTO::getId)).entrySet().stream().map(cadastro -> this.buildRoot(cadastro, (List)boletins.getOrDefault(cadastro.getKey(), new ArrayList()), (List)isencoes.getOrDefault(cadastro.getKey(), new ArrayList()))).collect(Collectors.toList());
    }

    private List<CadastroRuralCalculoDTO> loadCadatros(String filtro, Long exercicio) {
        String sql = String.format(FileUtils.readResourceAsString((String)CADASTRO_RURAL), filtro);
        MapSqlParameterSource parameters = new MapSqlParameterSource("exercicio", (Object)exercicio);
        Stopwatch stopwatch = Stopwatch.createStarted();
        List cadastros = this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new CadastroRuralCalculoDTORowMapper());
        stopwatch.stop();
        LOGGER.debug("Carregando {} cadastros rurais do banco - {} m {} s {} ms - {} ns", new Object[]{cadastros.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        return cadastros;
    }

    private Map<Long, List<RespostaDTO>> loadBoletim(String filtro, Set<CampoDinamicoScriptDTO> camposDinamicos) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String filtroCamposDinamicos = CadastroCalculoRepositoryUtils.buildFiltroCampoDinamico((TipoCampoDinamico)TipoCampoDinamico.CADASTRO, camposDinamicos);
        if (StringUtils.isBlank((CharSequence)filtroCamposDinamicos)) {
            return new HashMap<Long, List<RespostaDTO>>();
        }
        String sql = String.format(FileUtils.readResourceAsString((String)BOLETIM_RURAL), filtro, filtroCamposDinamicos);
        List result = this.namedParameterJdbcTemplate.query(sql, new HashMap(), (RowMapper)new ElotechBeanPropertyRowMapper(RespostaDTO.class));
        LOGGER.debug("Carregando {} boletim rural - {} m {} s {} ms - {} ns", new Object[]{result.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        return result.stream().collect(Collectors.groupingBy(RespostaDTO::getReferencia));
    }

    private Map<Long, List<CadastroIsencaoDTO>> loadIsencoes(String filtro, Long exercicio) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String sql = String.format(FileUtils.readResourceAsString((String)CADASTRO_ISENCOES), filtro);
        MapSqlParameterSource parameters = new MapSqlParameterSource("exercicio", (Object)exercicio);
        List result = this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(CadastroIsencaoDTO.class));
        LOGGER.debug("Carregando {} isencoes - {} m {} s {} ms - {} ns", new Object[]{result.size(), stopwatch.elapsed(TimeUnit.MINUTES), stopwatch.elapsed(TimeUnit.SECONDS), stopwatch.elapsed(TimeUnit.MILLISECONDS), stopwatch.elapsed(TimeUnit.NANOSECONDS)});
        return result.stream().collect(Collectors.groupingBy(CadastroIsencaoDTO::getIdCadastro));
    }

    private CadastroCalculoRoot buildRoot(Map.Entry<Long, List<CadastroRuralCalculoDTO>> cadastros, List<RespostaDTO> respostasRural, List<CadastroIsencaoDTO> isencoes) {
        CadastroCalculoRoot root = new CadastroCalculoRoot();
        root.setChildren(cadastros.getValue().stream().map(CadastroCalculoDTO.class::cast).collect(Collectors.toList()));
        root.setIsencoes(isencoes);
        if (!cadastros.getValue().isEmpty()) {
            root.setId(cadastros.getKey());
            root.setTipoCadastro(cadastros.getValue().get(0).getTipoCadastro());
            root.setCadastroGeral(cadastros.getValue().get(0).getCadastroGeral());
            Map boletimRural = CadastroCalculoRepositoryUtils.parseBoletim(respostasRural);
            cadastros.getValue().forEach(cadastro -> {
                cadastro.getCadastro().setBoletim(boletimRural);
                cadastro.getCadastro().setIsencoes(isencoes);
            });
        }
        return root;
    }
}

