/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.supersimples.solicitacao.importacao;

import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoCnpj;
import br.com.elotech.tributos.repository.supersimples.SuperSimplesSolicitacaoCnpjRepository;
import br.com.elotech.tributos.service.supersimples.ImportacaoSuperSimplesService;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ImportacaoSuperSimplesProcessor
implements ItemProcessor<SuperSimplesSolicitacaoCnpj, SuperSimplesSolicitacaoCnpj> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoSuperSimplesProcessor.class);
    private final ImportacaoSuperSimplesService importacaoSuperSimplesService;
    private final SuperSimplesSolicitacaoCnpjRepository superSimplesSolicitacaoCnpjRepository;
    private StepExecution stepExecution;
    private AtomicLong currentSequence;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        this.currentSequence = new AtomicLong(this.getLastSequenceNumber());
    }

    public SuperSimplesSolicitacaoCnpj process(SuperSimplesSolicitacaoCnpj item) {
        Long idSolicitacao = this.stepExecution.getJobExecution().getJobParameters().getLong("idSolicitacao");
        long sequencia = this.currentSequence.incrementAndGet();
        log.debug(String.format("Processando sequ\u00eancia %s da solicita\u00e7\u00e3o %s", sequencia, idSolicitacao));
        this.importacaoSuperSimplesService.processarBatch(item, idSolicitacao, sequencia);
        return item;
    }

    private long getLastSequenceNumber() {
        Long idSolicitacao = this.stepExecution.getJobExecution().getJobParameters().getLong("idSolicitacao");
        return this.superSimplesSolicitacaoCnpjRepository.findMaxSequenciaBySolicitacaoId(idSolicitacao);
    }

    @Generated
    public ImportacaoSuperSimplesProcessor(ImportacaoSuperSimplesService importacaoSuperSimplesService, SuperSimplesSolicitacaoCnpjRepository superSimplesSolicitacaoCnpjRepository) {
        this.importacaoSuperSimplesService = importacaoSuperSimplesService;
        this.superSimplesSolicitacaoCnpjRepository = superSimplesSolicitacaoCnpjRepository;
    }
}

