/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.supersimples.pgfn.importacao;

import br.com.elotech.arquivos.domain.request.ArquivoFindRequest;
import br.com.elotech.arquivos.domain.response.ArquivoContent;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.dto.supersimples.pgfn.PgfnArquivoItemDTO;
import br.com.elotech.tributos.dto.supersimples.pgfn.PgfnDadosDebitoDTO;
import br.com.elotech.tributos.dto.supersimples.pgfn.PgfnDadosDevedorOriginalDTO;
import br.com.elotech.tributos.dto.supersimples.pgfn.PgfnDadosDevedorPreferencialDTO;
import br.com.elotech.tributos.dto.supersimples.pgfn.PgfnEnderecoDevedorOriginalDTO;
import br.com.elotech.tributos.dto.supersimples.pgfn.PgfnEnderecoDevedorPreferencialDTO;
import br.com.elotech.tributos.enums.supersimples.pgfn.CampoArquivoPgfnEnum;
import br.com.elotech.tributos.service.resolvers.arquivoclient.ArquivoClientMinioResolver;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.DefaultLineMapper;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.batch.item.file.transform.FixedLengthTokenizer;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.batch.item.file.transform.Range;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@StepScope
public class ImportacaoArquivoPgfnReader
extends FlatFileItemReader<PgfnArquivoItemDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoArquivoPgfnReader.class);
    private static final String HEADER_REGISTRO = "0";
    private static final String CONTEUDO_REGISTRO = "1";
    private static final String FOOTER_REGISTRO = "2";

    public ImportacaoArquivoPgfnReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, ArquivoStorageFeignClient arquivoStorageFeignClient, ArquivoClientMinioResolver arquivoClientMinioResolver) {
        Long idArquivo = (Long)jobParameters.get("idArquivo");
        this.setResource((Resource)new InputStreamResource(this.getFileStream(idArquivo, arquivoClientMinioResolver, arquivoStorageFeignClient)));
        this.setLineMapper((LineMapper)this.buildLineMapper());
    }

    private InputStream getFileStream(Long idArquivo, ArquivoClientMinioResolver minioResolver, ArquivoStorageFeignClient feignClient) {
        ArquivoDTO arquivoDto = feignClient.findOne(idArquivo);
        log.debug("Buscando url de download do arquivo");
        ArquivoFindRequest arquivoFindRequest = ArquivoFindRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getTenantId().orElse("")), (String)arquivoDto.getFullPath());
        return minioResolver.getArquivoClient().buscarArquivo(arquivoFindRequest).map(ArquivoContent::getContent).orElseThrow(() -> new EloValidationException("Erro ao baixar o arquivo"));
    }

    private DefaultLineMapper<PgfnArquivoItemDTO> buildLineMapper() {
        DefaultLineMapper lineMapper = new DefaultLineMapper();
        lineMapper.setLineTokenizer((LineTokenizer)ImportacaoArquivoPgfnReader.createLineTokenizer());
        lineMapper.setFieldSetMapper(arg_0 -> this.mapLineToDTO(arg_0));
        return lineMapper;
    }

    private static FixedLengthTokenizer createLineTokenizer() {
        FixedLengthTokenizer fixedLengthTokenizer = new FixedLengthTokenizer();
        String[] nomes = (String[])Arrays.stream(CampoArquivoPgfnEnum.values()).map(CampoArquivoPgfnEnum::getNome).toArray(String[]::new);
        Range[] ranges = (Range[])Arrays.stream(CampoArquivoPgfnEnum.values()).map(campo -> new Range(campo.getInicio(), campo.getInicio() + campo.getTamanho() - 1)).toArray(Range[]::new);
        fixedLengthTokenizer.setNames(nomes);
        fixedLengthTokenizer.setColumns(ranges);
        fixedLengthTokenizer.setStrict(false);
        return fixedLengthTokenizer;
    }

    public PgfnArquivoItemDTO mapLineToDTO(FieldSet fieldSet) {
        String identificacaoRegistro;
        switch (identificacaoRegistro = fieldSet.readString(CampoArquivoPgfnEnum.TIPO_REGISTRO.getNome())) {
            case "0": {
                return new PgfnArquivoItemDTO();
            }
            case "2": {
                return null;
            }
            case "1": {
                return this.buildRegistroDadosPgfnDTO(fieldSet);
            }
        }
        throw new IllegalArgumentException("Tipo de linha desconhecido: " + identificacaoRegistro);
    }

    public PgfnArquivoItemDTO buildRegistroDadosPgfnDTO(FieldSet fieldSet) {
        PgfnArquivoItemDTO pgfnArquivoItemDTO = new PgfnArquivoItemDTO();
        pgfnArquivoItemDTO.setDadosDevedorPreferencial(new PgfnDadosDevedorPreferencialDTO(fieldSet));
        pgfnArquivoItemDTO.setEnderecoDevedorPreferencial(new PgfnEnderecoDevedorPreferencialDTO(fieldSet));
        pgfnArquivoItemDTO.setDadosDevedorOriginal(new PgfnDadosDevedorOriginalDTO(fieldSet));
        pgfnArquivoItemDTO.setEnderecoDevedorOriginal(new PgfnEnderecoDevedorOriginalDTO(fieldSet));
        pgfnArquivoItemDTO.setDadosDebito(new PgfnDadosDebitoDTO(fieldSet));
        return pgfnArquivoItemDTO;
    }
}

