/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.supersimples.pgfn.importacao;

import br.com.elotech.tributos.domain.supersimples.pgfn.PgfnArquivo;
import br.com.elotech.tributos.domain.supersimples.pgfn.PgfnDadosDebito;
import br.com.elotech.tributos.domain.supersimples.pgfn.PgfnDadosDevedorOriginal;
import br.com.elotech.tributos.domain.supersimples.pgfn.PgfnDadosDevedorPreferencial;
import br.com.elotech.tributos.domain.supersimples.pgfn.PgfnEnderecoDevedorOriginal;
import br.com.elotech.tributos.domain.supersimples.pgfn.PgfnEnderecoDevedorPreferencial;
import br.com.elotech.tributos.dto.supersimples.pgfn.PgfnArquivoItemDTO;
import br.com.elotech.tributos.dto.supersimples.pgfn.PgfnArquivoItemEntityDTO;
import br.com.elotech.tributos.repository.supersimples.pgfn.PgfnArquivoRepository;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ImportacaoArquivoPgfnProcessor
implements ItemProcessor<PgfnArquivoItemDTO, PgfnArquivoItemEntityDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoArquivoPgfnProcessor.class);
    private final PgfnArquivoRepository pgfnArquivoRepository;
    private StepExecution stepExecution;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public PgfnArquivoItemEntityDTO process(PgfnArquivoItemDTO item) {
        if (item.getDadosDevedorPreferencial() == null) {
            return null;
        }
        Long idArquivoPgfn = this.stepExecution.getJobExecution().getJobParameters().getLong("idArquivoPgfn");
        PgfnArquivo pgfnArquivo = (PgfnArquivo)this.pgfnArquivoRepository.findOne((Object)idArquivoPgfn);
        PgfnDadosDevedorPreferencial devedorPreferencial = this.createDadosDevedorPreferencial(item, pgfnArquivo);
        PgfnEnderecoDevedorPreferencial enderecoDevedorPreferencial = this.createEnderecoDevedorPreferencial(item, pgfnArquivo, devedorPreferencial);
        PgfnDadosDevedorOriginal devedorOriginal = this.createDadosDevedorOriginal(item, pgfnArquivo);
        PgfnEnderecoDevedorOriginal enderecoDevedorOriginal = this.createEnderecoDevedorOriginal(item, pgfnArquivo, devedorOriginal);
        PgfnDadosDebito dadosDebito = this.createDadosDebito(item, pgfnArquivo, devedorPreferencial, devedorOriginal);
        return this.buildPgfnArquivoItemEntity(devedorPreferencial, enderecoDevedorPreferencial, devedorOriginal, enderecoDevedorOriginal, dadosDebito);
    }

    private PgfnDadosDevedorPreferencial createDadosDevedorPreferencial(PgfnArquivoItemDTO item, PgfnArquivo pgfnArquivo) {
        PgfnDadosDevedorPreferencial devedorPreferencial = item.getDadosDevedorPreferencial().toEntity();
        devedorPreferencial.setPgfnArquivo(pgfnArquivo);
        return devedorPreferencial;
    }

    private PgfnEnderecoDevedorPreferencial createEnderecoDevedorPreferencial(PgfnArquivoItemDTO item, PgfnArquivo pgfnArquivo, PgfnDadosDevedorPreferencial devedorPreferencial) {
        PgfnEnderecoDevedorPreferencial enderecoDevedorPreferencial = item.getEnderecoDevedorPreferencial().toEntity();
        enderecoDevedorPreferencial.setPgfnArquivo(pgfnArquivo);
        enderecoDevedorPreferencial.setPgfnDadosDevedorPreferencial(devedorPreferencial);
        return enderecoDevedorPreferencial;
    }

    private PgfnDadosDevedorOriginal createDadosDevedorOriginal(PgfnArquivoItemDTO item, PgfnArquivo pgfnArquivo) {
        PgfnDadosDevedorOriginal devedorOriginal = item.getDadosDevedorOriginal().toEntity();
        devedorOriginal.setPgfnArquivo(pgfnArquivo);
        return devedorOriginal;
    }

    private PgfnEnderecoDevedorOriginal createEnderecoDevedorOriginal(PgfnArquivoItemDTO item, PgfnArquivo pgfnArquivo, PgfnDadosDevedorOriginal devedorOriginal) {
        PgfnEnderecoDevedorOriginal enderecoDevedorOriginal = item.getEnderecoDevedorOriginal().toEntity();
        enderecoDevedorOriginal.setPgfnArquivo(pgfnArquivo);
        enderecoDevedorOriginal.setPgfnDadosDevedorOriginal(devedorOriginal);
        return enderecoDevedorOriginal;
    }

    private PgfnDadosDebito createDadosDebito(PgfnArquivoItemDTO item, PgfnArquivo pgfnArquivo, PgfnDadosDevedorPreferencial devedorPreferencial, PgfnDadosDevedorOriginal devedorOriginal) {
        PgfnDadosDebito dadosDebito = item.getDadosDebito().toEntity();
        dadosDebito.setPgfnArquivo(pgfnArquivo);
        dadosDebito.setDadosDevedorPreferencial(devedorPreferencial);
        dadosDebito.setDadosDevedorOriginal(devedorOriginal);
        return dadosDebito;
    }

    private PgfnArquivoItemEntityDTO buildPgfnArquivoItemEntity(PgfnDadosDevedorPreferencial devedorPreferencial, PgfnEnderecoDevedorPreferencial enderecoDevedorPreferencial, PgfnDadosDevedorOriginal devedorOriginal, PgfnEnderecoDevedorOriginal enderecoDevedorOriginal, PgfnDadosDebito dadosDebito) {
        PgfnArquivoItemEntityDTO pgfnArquivoItemEntity = new PgfnArquivoItemEntityDTO();
        pgfnArquivoItemEntity.setDevedorPreferencial(devedorPreferencial);
        pgfnArquivoItemEntity.setEnderecoDevedorPreferencial(enderecoDevedorPreferencial);
        pgfnArquivoItemEntity.setDevedorOriginal(devedorOriginal);
        pgfnArquivoItemEntity.setEnderecoDevedorOriginal(enderecoDevedorOriginal);
        pgfnArquivoItemEntity.setDadosDebito(dadosDebito);
        return pgfnArquivoItemEntity;
    }

    @Generated
    public ImportacaoArquivoPgfnProcessor(PgfnArquivoRepository pgfnArquivoRepository) {
        this.pgfnArquivoRepository = pgfnArquivoRepository;
    }
}

