/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.supersimples.dassenda.importacao;

import br.com.elotech.tributos.domain.supersimples.dassenda.DassendaArquivo;
import br.com.elotech.tributos.domain.supersimples.dassenda.DassendaArquivoAbertura;
import br.com.elotech.tributos.domain.supersimples.dassenda.DassendaArquivoCalculo;
import br.com.elotech.tributos.domain.supersimples.dassenda.DassendaArquivoCalculoItem;
import br.com.elotech.tributos.dto.supersimples.dassenda.DassendaArquivoAberturaDTO;
import br.com.elotech.tributos.dto.supersimples.dassenda.DassendaArquivoItemDTO;
import br.com.elotech.tributos.dto.supersimples.dassenda.DassendaArquivoItemEntityDTO;
import br.com.elotech.tributos.repository.supersimples.dassenda.DassendaArquivoRepository;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ImportacaoArquivoDassendaProcessor
implements ItemProcessor<DassendaArquivoItemDTO, DassendaArquivoItemEntityDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoArquivoDassendaProcessor.class);
    private final DassendaArquivoRepository dassendaArquivoRepository;
    private DassendaArquivo dassendaArquivo;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        Long idArquivoDassenda = stepExecution.getJobExecution().getJobParameters().getLong("idArquivoDassenda");
        this.dassendaArquivo = (DassendaArquivo)this.dassendaArquivoRepository.findOne((Object)idArquivoDassenda);
    }

    public DassendaArquivoItemEntityDTO process(DassendaArquivoItemDTO item) {
        if (item.getAbertura() != null) {
            return this.processarAbertura(item.getAbertura());
        }
        if (item.getCalculo() != null) {
            return this.processarCalculo(item);
        }
        return null;
    }

    private DassendaArquivoItemEntityDTO processarCalculo(DassendaArquivoItemDTO itemDTO) {
        DassendaArquivoCalculo calculo = itemDTO.getCalculo().toEntity();
        calculo.setDassendaArquivo(this.dassendaArquivo);
        List calculoItens = itemDTO.getCalculoItens();
        calculoItens.forEach(calculoItemDTO -> {
            DassendaArquivoCalculoItem calculoItem = calculoItemDTO.toEntity();
            calculoItem.setDassendaArquivo(this.dassendaArquivo);
            calculoItem.setDassendaArquivoCalculo(calculo);
            calculo.getItens().add(calculoItem);
        });
        DassendaArquivoItemEntityDTO dassendaArquivoItemEntityDTO = new DassendaArquivoItemEntityDTO();
        dassendaArquivoItemEntityDTO.setCalculo(calculo);
        return dassendaArquivoItemEntityDTO;
    }

    private DassendaArquivoItemEntityDTO processarAbertura(DassendaArquivoAberturaDTO aberturaDTO) {
        DassendaArquivoAbertura abertura = aberturaDTO.toEntity();
        abertura.setDassendaArquivo(this.dassendaArquivo);
        DassendaArquivoItemEntityDTO dassendaArquivoItemEntityDTO = new DassendaArquivoItemEntityDTO();
        dassendaArquivoItemEntityDTO.setAbertura(abertura);
        return dassendaArquivoItemEntityDTO;
    }

    @Generated
    public ImportacaoArquivoDassendaProcessor(DassendaArquivoRepository dassendaArquivoRepository) {
        this.dassendaArquivoRepository = dassendaArquivoRepository;
    }
}

