/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.supersimples.dassenda.importacao;

import br.com.elotech.tributos.dto.supersimples.dassenda.DassendaArquivoItemEntityDTO;
import br.com.elotech.tributos.repository.supersimples.dassenda.DassendaArquivoAberturaRepository;
import br.com.elotech.tributos.repository.supersimples.dassenda.DassendaArquivoCalculoRepository;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class ImportacaoArquivoDassendaBatchWriter
implements ItemWriter<DassendaArquivoItemEntityDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoArquivoDassendaBatchWriter.class);
    private final DassendaArquivoAberturaRepository aberturaRepository;
    private final DassendaArquivoCalculoRepository calculoRepository;
    private StepExecution stepExecution;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends DassendaArquivoItemEntityDTO> items) throws Exception {
        List itensValidos = items.stream().filter(item -> item.getAbertura() != null || item.getCalculo() != null && !item.getCalculo().getItens().isEmpty()).collect(Collectors.toList());
        for (DassendaArquivoItemEntityDTO item2 : itensValidos) {
            if (item2.getAbertura() != null) {
                this.aberturaRepository.save((Object)item2.getAbertura());
            }
            if (item2.getCalculo() == null) continue;
            this.calculoRepository.save((Object)item2.getCalculo());
        }
    }

    @AfterWrite
    public void afterWrite(List<? extends DassendaArquivoItemEntityDTO> items) {
        Long idArquivoDassenda = this.stepExecution.getJobExecution().getJobParameters().getLong("idArquivoDassenda");
        int quantidadeProcessada = this.stepExecution.getReadCount() + items.size();
        log.info("Finalizado chunk do arquivo DASSENDA {}. Itens processados at\u00e9 o momento {}", (Object)idArquivoDassenda, (Object)quantidadeProcessada);
    }

    @Generated
    public ImportacaoArquivoDassendaBatchWriter(DassendaArquivoAberturaRepository aberturaRepository, DassendaArquivoCalculoRepository calculoRepository) {
        this.aberturaRepository = aberturaRepository;
        this.calculoRepository = calculoRepository;
    }
}

