/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.validaregrasimportacao;

import br.com.elotech.tributos.enums.NotificationStatus;
import br.com.elotech.tributos.notification.impl.ValidacaoImportacaoSimAmNotification;
import java.time.LocalDateTime;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class ValidaRegrasImportacaoSimAMStepListener
extends StepExecutionListenerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidaRegrasImportacaoSimAMStepListener.class);
    private final ValidacaoImportacaoSimAmNotification importacaoSimAmNotification;

    public ExitStatus afterStep(StepExecution stepExecution) {
        super.afterStep(stepExecution);
        int item = stepExecution.getJobExecution().getStepExecutions().size();
        log.debug("Notificando progresso de item {} da etapa {} - as {}", new Object[]{item, stepExecution.getStepName(), LocalDateTime.now()});
        if (stepExecution.getExitStatus().equals((Object)ExitStatus.COMPLETED)) {
            this.importacaoSimAmNotification.notify(stepExecution, item, NotificationStatus.PROGRESS);
        }
        if (!stepExecution.getExitStatus().equals((Object)ExitStatus.COMPLETED)) {
            this.importacaoSimAmNotification.notify(stepExecution, item, NotificationStatus.ERROR);
        }
        return stepExecution.getExitStatus();
    }

    @Generated
    public ValidaRegrasImportacaoSimAMStepListener(ValidacaoImportacaoSimAmNotification importacaoSimAmNotification) {
        this.importacaoSimAmNotification = importacaoSimAmNotification;
    }
}

