/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.implantacaosaldo;

import br.com.elotech.tributos.domain.simam.ImplantacaoSaldoItem;
import br.com.elotech.tributos.repository.simam.ImplantacaoSaldoItemRepository;
import java.util.List;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class ImplantacaoSaldoBatchWriter
implements ItemWriter<ImplantacaoSaldoItem> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImplantacaoSaldoBatchWriter.class);
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final ImplantacaoSaldoItemRepository implantacaoSaldoItemRepository;

    public ImplantacaoSaldoBatchWriter(EntityManager entityManager, ImplantacaoSaldoItemRepository implantacaoSaldoItemRepository) {
        this.entityManager = entityManager;
        this.implantacaoSaldoItemRepository = implantacaoSaldoItemRepository;
    }

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    @AfterWrite
    public void afterWrite(List<? extends ImplantacaoSaldoItem> items) {
        LOGGER.info("SIM-AM - Implanta\u00e7\u00e3o de Saldo - Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + items.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    public void write(List<? extends ImplantacaoSaldoItem> items) {
        this.implantacaoSaldoItemRepository.saveAll(items);
        this.entityManager.flush();
    }
}

