/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.ajustenrcreditoenrdivida;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.batch.simam.ajustenrcreditoenrdivida.AtribuirNrCreditoNrDividaJobListener;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class AtribuirNrCreditoNrDividaJobListener
extends JobExecutionListenerSupport {
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String TIPO_ARQUIVO = "tipo";
    private final NotificacaoService notificacaoService;

    public void beforeJob(@Nullable JobExecution jobExecution) {
        if (Objects.isNull(jobExecution)) {
            return;
        }
        super.beforeJob(jobExecution);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        Long tipo = jobExecution.getJobParameters().getLong(TIPO_ARQUIVO);
        TipoRegistroSimAm tipoRegistroSimAm = TipoRegistroSimAm.getByCodigo((Long)tipo);
        String context = this.getContext(tipoRegistroSimAm);
        String message = String.format("Iniciado o processo para atribui\u00e7\u00e3o de %s com filtro %s at\u00e9 %s. ", context, dataInicial, dataFinal);
        message = tipo == null ? "" : String.format("%s %s", message, "Tipo de arquivo: " + tipo);
        Optional notificacaoId = this.notificacaoService.send(String.format("Atribuir %s - Iniciando atribui\u00e7\u00f5es", context), message, jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(@Nullable JobExecution jobExecution) {
        if (Objects.isNull(jobExecution)) {
            return;
        }
        super.afterJob(jobExecution);
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_INICIAL)));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA_FINAL)));
        Long tipo = jobExecution.getJobParameters().getLong(TIPO_ARQUIVO);
        TipoRegistroSimAm tipoRegistroSimAm = TipoRegistroSimAm.getByCodigo((Long)tipo);
        String context = this.getContext(tipoRegistroSimAm);
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        String message = String.format("Finalizado o processo para atribui\u00e7\u00e3o de %s com filtro %s at\u00e9 %s. ", context, dataInicial, dataFinal);
        String string = message = tipo == null ? "" : String.format("%s %s", message, "Tipo de arquivo: " + tipo);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send(String.format("Atribuir %s - Sucesso ao Atribuir %s", context, context), message, jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            message = String.format("Ocorreu algum erro na tentativa de Atribuir %s para o  filtro %s at\u00e9 %s. ", context, dataInicial, dataFinal);
            message = tipo == null ? "" : String.format("%s %s", message, "Tipo de arquivo: " + tipo);
            this.notificacaoService.send(String.format("Atribuir %s - Erro ao Tentar Atribuir %s", context, context), message, jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    private String getContext(TipoRegistroSimAm tipoRegistroSimAm) {
        if (tipoRegistroSimAm == null || TipoRegistroSimAm.ARRECADACAO_TIPO_CREDITO.equals((Object)tipoRegistroSimAm)) {
            return "nrCredito e NrDivida";
        }
        return this.isNrCreditoContext(tipoRegistroSimAm) ? "nrCredito" : "nrDivida";
    }

    private boolean isNrCreditoContext(TipoRegistroSimAm tipoRegistroSimAm) {
        switch (1.$SwitchMap$br$com$elotech$tributos$enums$TipoRegistroSimAm[tipoRegistroSimAm.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Generated
    public AtribuirNrCreditoNrDividaJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

