/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.sanepar.importacao;

import br.com.elotech.tributos.domain.sanepar.BaixaSanepar;
import br.com.elotech.tributos.domain.sanepar.BaixaSaneparItem;
import br.com.elotech.tributos.enums.sanepar.SituacaoItemSanepar;
import br.com.elotech.tributos.repository.sanepar.BaixaSaneparItemRepository;
import br.com.elotech.tributos.service.ContextService;
import java.util.List;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class ImportacaoSaneparBatchWriter
implements ItemWriter<BaixaSaneparItem> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoSaneparBatchWriter.class);
    private final BaixaSaneparItemRepository baixaSaneparItemRepository;
    private final EntityManager entityManager;
    private final ContextService contextService;
    private StepExecution stepExecution;

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends BaixaSaneparItem> items) throws Exception {
        Long idBaixa = this.stepExecution.getJobExecution().getJobParameters().getLong("idBaixa");
        BaixaSanepar baixa = (BaixaSanepar)this.entityManager.getReference(BaixaSanepar.class, (Object)idBaixa);
        Long entidade = this.contextService.getEntidadePrincipal();
        items.forEach(item -> {
            item.setSituacao(SituacaoItemSanepar.IMPORTADO);
            item.setMensagem("Importado com Sucesso");
            item.setBaixa(baixa);
            item.setEntidade(entidade);
        });
        this.baixaSaneparItemRepository.saveAll(items);
        log.info("Finalizado chunk do lote {}. itens escritos: {}", (Object)idBaixa, (Object)this.stepExecution.getWriteCount());
    }

    @Generated
    public ImportacaoSaneparBatchWriter(BaixaSaneparItemRepository baixaSaneparItemRepository, EntityManager entityManager, ContextService contextService) {
        this.baixaSaneparItemRepository = baixaSaneparItemRepository;
        this.entityManager = entityManager;
        this.contextService = contextService;
    }
}

