/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cda.simulacao;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.documento.cda.LoteCda;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItem;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItemDetalhe;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItemPessoa;
import br.com.elotech.tributos.dto.DividaDTO;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.dto.documento.cda.DebitoGeracaoCdaDTO;
import br.com.elotech.tributos.dto.documento.cda.GeracaoLoteCdaDTO;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.documento.cda.LoteCdaItemService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class SimulacaoLoteCdaBatchProcessor
implements ItemProcessor<DebitoGeracaoCdaDTO, LoteCdaItem> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimulacaoLoteCdaBatchProcessor.class);
    private static final String ID_LOTE = "idLote";
    private static final String ENTIDADE = "entidade";
    private static final String GERACAO_LOTE_CDA_DTO = "geracaoLoteCdaDto";
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final FormaPagamentoService formaPagamentoService;
    private final CadastroGeralService cadastroGeralService;
    private final LoteCdaItemService loteCdaItemService;
    private final ObjectMapper objectMapper;
    private final EntityManager entityManager;
    private Long idLote;
    private Long idEntidade;
    private boolean incluiTodosProprietarios;
    private ListasNecessariasCalculaAcrescimoDTO listasNecessariasCalculaAcrescimoDTO;
    private AtomicLong sequencia;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) throws JsonProcessingException {
        this.idLote = stepExecution.getJobParameters().getLong(ID_LOTE);
        this.idEntidade = stepExecution.getJobParameters().getLong(ENTIDADE);
        this.incluiTodosProprietarios = ((GeracaoLoteCdaDTO)this.objectMapper.readValue(stepExecution.getJobParameters().getString(GERACAO_LOTE_CDA_DTO), GeracaoLoteCdaDTO.class)).getIncluiTodosProprietarios();
        this.sequencia = new AtomicLong(this.loteCdaItemService.getNextItemSequenceByLoteId(this.idLote));
        log.info("Iniciando processamento da simula\u00e7\u00e3o do lote de CDA - IdLote: {}, JobExecutionId: {}.", (Object)this.idLote, (Object)stepExecution.getJobExecution().getId());
    }

    public LoteCdaItem process(DebitoGeracaoCdaDTO debito) {
        this.initializeListasNecessariasCalculaAcrescimo();
        this.calculateAcrescimo(debito);
        LoteCdaItem item = this.processLoteCdaItem(debito);
        log.info("Processando LoteCdaItem - LoteCdaItem.Id: {}, LoteCdaItemDetalhe.Id: {}.", (Object)item.getId(), (Object)((LoteCdaItemDetalhe)item.getItemDetalhes().get(item.getItemDetalhes().size() - 1)).getId());
        return item;
    }

    private void initializeListasNecessariasCalculaAcrescimo() {
        if (Objects.isNull(this.listasNecessariasCalculaAcrescimoDTO)) {
            this.listasNecessariasCalculaAcrescimoDTO = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
        }
    }

    private LoteCdaItem processLoteCdaItem(DebitoGeracaoCdaDTO debito) {
        LoteCdaItem item = Boolean.TRUE.equals(debito.getCdaIndividual()) ? this.loteCdaItemService.findByIdLoteAndIdDebito(this.idLote, debito.getIdDebito()) : this.loteCdaItemService.findByIdLoteAndIdCadastroGeral(this.idLote, debito.getIdCadastroGeral());
        if (Objects.nonNull(item)) {
            return this.updateItem(item, debito);
        }
        return this.updateLoteAndGetItem(debito);
    }

    private LoteCdaItem updateItem(LoteCdaItem item, DebitoGeracaoCdaDTO debito) {
        item.addDetalhe(this.createLoteCdaItemDetalhe(debito));
        this.loteCdaItemService.save((EloEntity)item, null);
        return item;
    }

    private LoteCdaItem updateLoteAndGetItem(DebitoGeracaoCdaDTO debito) {
        LoteCdaItem item = this.createLoteCdaItem(debito, Long.valueOf(this.sequencia.getAndIncrement()));
        item.addDetalhe(this.createLoteCdaItemDetalhe(debito));
        item.setLote((LoteCda)this.entityManager.getReference(LoteCda.class, (Object)this.idLote));
        this.loteCdaItemService.save((EloEntity)item, null);
        return item;
    }

    private void calculateAcrescimo(DebitoGeracaoCdaDTO debito) {
        FormaPagamento formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        AcrescimoDTO acrescimo = new AcrescimoDTO();
        acrescimo.setEntidade(this.idEntidade);
        acrescimo.setExercicio(debito.getExercicioDebito());
        acrescimo.setDataLancamento(debito.getDataLancamento());
        acrescimo.setDataPrimeiraParcela(debito.getDataPrimeiraParcela());
        acrescimo.setDataReferencia(LocalDate.now());
        acrescimo.setDataVencimento(debito.getDataVencimento());
        acrescimo.setDataVencimentoOriginal(debito.getDataVencimento());
        acrescimo.setFormaCorrecao(debito.getFormaCorrecao());
        acrescimo.setParcelado(Boolean.valueOf(debito.getParcelado() != false || debito.getReparcelado() != false));
        acrescimo.setSituacaoLegal(SituacaoLegal.fromValue((Integer)debito.getSituacaoLegal().intValue()));
        acrescimo.setTributo(debito.getTributo());
        acrescimo.setValor(debito.getValor());
        acrescimo.setFormaPagamento(formaPagamento.getId());
        DividaDTO divida = new DividaDTO();
        divida.setId(debito.getIdDivida());
        divida.setExercicio(debito.getExercicioDebito());
        divida.setDivida(debito.getDivida());
        divida.setEntidade(this.idEntidade);
        acrescimo.setDivida(divida);
        acrescimo.setCalculaValorDesconto(Boolean.FALSE);
        this.calculoAcrescimoService.calculaAcrescimos(acrescimo, Optional.ofNullable(this.listasNecessariasCalculaAcrescimoDTO));
        debito.setValor(acrescimo.getValor());
        debito.setValorJuros(acrescimo.getValorJuros());
        debito.setValorMulta(acrescimo.getValorMulta());
        debito.setValorCorrecao(acrescimo.getValorCorrecao());
    }

    private LoteCdaItem createLoteCdaItem(DebitoGeracaoCdaDTO debito, Long sequencia) {
        CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)debito.getTipoCadastro()), debito.getCadastroGeral()).orElseThrow(() -> new IllegalArgumentException("Cadastro Geral n\u00e3o encontrado"));
        LoteCdaItem item = new LoteCdaItem();
        item.setCadastroGeral(cadastroGeral);
        item.getItemPessoas().addAll(this.getProprietarios(cadastroGeral).stream().map(pessoa -> LoteCdaItemPessoa.of((Pessoa)pessoa, (LoteCdaItem)item, (Boolean)this.isResponsavelPrincipal(pessoa, item))).collect(Collectors.toList()));
        item.setSequencia(sequencia);
        return item;
    }

    private LoteCdaItemDetalhe createLoteCdaItemDetalhe(DebitoGeracaoCdaDTO debito) {
        LoteCdaItemDetalhe detalhe = new LoteCdaItemDetalhe();
        detalhe.setValor(debito.getValor());
        detalhe.setValorJuros(debito.getValorJuros());
        detalhe.setValorMulta(debito.getValorMulta());
        detalhe.setValorCorrecao(debito.getValorCorrecao());
        DebitoParcelaTributo debitoParcelaTributo = new DebitoParcelaTributo();
        debitoParcelaTributo.setId(debito.getIdDebitoParcelaTributo());
        detalhe.setParcelaTributo(debitoParcelaTributo);
        return detalhe;
    }

    private List<Pessoa> getProprietarios(CadastroGeral cadastroGeral) {
        if (this.incluiTodosProprietarios) {
            return this.cadastroGeralService.getTodosResponsaveis(cadastroGeral);
        }
        return Collections.singletonList(this.cadastroGeralService.getResponsavelPrincipal(cadastroGeral));
    }

    @OnProcessError
    public void onProcessError(DebitoGeracaoCdaDTO debito, Exception e) throws JsonProcessingException {
        log.error("CDA - Simula\u00e7\u00e3o do Lote de CDA - erro: {}\n{})", (Object)e.getMessage(), (Object)this.objectMapper.writeValueAsString((Object)debito));
    }

    private boolean isResponsavelPrincipal(Pessoa responsavel, LoteCdaItem loteCdaItem) {
        CadastroGeral cadastroGeral = loteCdaItem.getCadastroGeral();
        boolean isMobiliario = Boolean.TRUE.equals(cadastroGeral.getTipoCadastro().isMobiliario());
        if (isMobiliario) {
            return cadastroGeral.getPessoa().equals((Object)responsavel);
        }
        return cadastroGeral.getProprietarioPrincipal().map(Proprietario::getPessoa).filter(principal -> principal.equals((Object)responsavel)).isPresent();
    }

    @Generated
    public SimulacaoLoteCdaBatchProcessor(CalculoAcrescimoService calculoAcrescimoService, FormaPagamentoService formaPagamentoService, CadastroGeralService cadastroGeralService, LoteCdaItemService loteCdaItemService, ObjectMapper objectMapper, EntityManager entityManager) {
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.formaPagamentoService = formaPagamentoService;
        this.cadastroGeralService = cadastroGeralService;
        this.loteCdaItemService = loteCdaItemService;
        this.objectMapper = objectMapper;
        this.entityManager = entityManager;
    }
}

