/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cda.simulacao;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.dto.documento.cda.GeracaoLoteCdaDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.JobExecutionDecider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;

public class SimulacaoLoteCdaBatchDecider
implements JobExecutionDecider {
    private static final String GERACAO_LOTE_CDA_DTO = "geracaoLoteCdaDto";
    private static final String FILTER_VALOR_MINIMO_CERTIDAO = "filterValorMinimoCertidao";
    @Autowired
    private ObjectMapper objectMapper;

    private GeracaoLoteCdaDTO getParamGeracaoLoteCdaDTO(JobParameters jobParameters) {
        try {
            return (GeracaoLoteCdaDTO)this.objectMapper.readValue(jobParameters.getString(GERACAO_LOTE_CDA_DTO), GeracaoLoteCdaDTO.class);
        }
        catch (JsonProcessingException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, "Erro ao converter par\u00e2metros da simula\u00e7\u00e3o do lote de cda.", (Throwable)e);
        }
    }

    private boolean hasValorMinimoCertidao(JobParameters jobParameters) {
        BigDecimal valorMinimoCertidao = this.getParamGeracaoLoteCdaDTO(jobParameters).getValorMinimoCertidao();
        return !BigDecimal.ZERO.equals(valorMinimoCertidao);
    }

    public FlowExecutionStatus decide(JobExecution jobExecution, StepExecution stepExecution) {
        if (this.hasValorMinimoCertidao(jobExecution.getJobParameters())) {
            return new FlowExecutionStatus(FILTER_VALOR_MINIMO_CERTIDAO);
        }
        return FlowExecutionStatus.COMPLETED;
    }
}

