select nq.nrDivida as nr,
       nq.nrAnoDivida as nrAno,
       nq.valorSoma as valorSoma
from
(
  select soma.nrDivida,
         soma.nrAnoDivida,
         sum(soma.vlinscricao + soma.vlEstornoInscricao + soma.vlatualizacao + soma.vlEstornoAtualizacao +
             soma.vlDeducao + soma.vlEstornoDeducao + soma.vlArrecadacao + soma.vlEstornoArrecadacao) as valorSoma
  from
  (
    select filtro.nrDivida,
           filtro.nrAnoDivida,
           sum(filtro.vlinscricao) as vlinscricao,
           sum(case when icde.vlEstornoInscricao   is null then 0 else icde.vlEstornoInscricao end   ) as vlEstornoInscricao,
           sum(case when tamc.vlatualizacao         is null then 0 else tamc.vlatualizacao end         ) as vlatualizacao,
           sum(case when tamce.vlEstornoAtualizacao is null then 0 else tamce.vlEstornoAtualizacao end ) as vlEstornoAtualizacao,
           sum(case when tdc.vlDeducao              is null then 0 else tdc.vlDeducao end              ) as vlDeducao,
           sum(case when tdce.vlEstornoDeducao      is null then 0 else tdce.vlEstornoDeducao end      ) as vlEstornoDeducao,
           sum(case when atc.vlArrecadacao          is null then 0 else atc.vlArrecadacao end          ) as vlArrecadacao,
           sum(case when atce.vlEstornoArrecadacao  is null then 0 else atc.vlArrecadacao end          ) as vlEstornoArrecadacao
    from
    (
      select icd.nrdivida,
             icd.nranodivida,
             coalesce(icd.vlinscricao, 0) as vlinscricao
      from tceInscCreditoDA  icd
      where icd.idTipoCredito = :idTipoCredito
        and icd.dtinscricao <= :dataLancamento
    ) filtro
    left join (
      select icde.nrdivida,
             icde.nranodivida,
             sum(coalesce(icde.vlestorno,0)*-1) as vlEstornoInscricao
      from tceInscCreditoDAEst icde
      group by icde.nrDivida, icde.nrAnoDivida
    ) icde on icde.nrDivida = filtro.nrDivida and icde.nrAnoDivida = filtro.nrAnoDivida
    left join (
      select tamc.nrdivida,
             tamc.nranodivida,
             sum(coalesce(tamc.vlatualizacao,0)) as vlatualizacao
      from tceAtualizaMoneCredDA tamc
      group by tamc.nrDivida, tamc.nrAnoDivida
    ) tamc on tamc.nrDivida = filtro.nrDivida and tamc.nrAnoDivida = filtro.nrAnoDivida
    left join (
      select tamc.nrDivida,
             tamc.nrAnoDivida,
             sum(coalesce(tamce.vlestorno,0) *-1) as vlEstornoAtualizacao
      from tceAtualizaMoneCreddaEst tamce
      join tceatualizaMoneCredda    tamc on tamc.nrAtualizacao = tamce.nrAtualizacao
                                        and tamc.nrAnoAtualizacao = tamce.nrAnoAtualizacao
      group by tamc.nrDivida, tamc.nrAnoDivida
    ) tamce on tamce.nrDivida = filtro.nrDivida and tamce.nrAnoDivida = filtro.nrAnoDivida
    left join (
      select tdc.nrDivida,
             tdc.nrAnoDivida,
             sum(coalesce(tdc.vlDeducao, 0)*-1) as vlDeducao
      from tceDeducaoCreditoDA tdc
      group by tdc.nrDivida, tdc.nrAnoDivida
    ) tdc on tdc.nrDivida = filtro.nrDivida and tdc.nrAnoDivida = filtro.nrAnoDivida
    left join (
      select tdc.nrDivida,
             tdc.nrAnoDivida,
             sum(coalesce(tdce.vlEstorno, 0)) as vlEstornoDeducao
      from tceDeducaoCreditoDAEst tdce
      join tceDeducaoCreditoDA    tdc on tdc.nrAnoDeducao = tdce.nrAnoDeducao and tdc.nrDeducao = tdce.nrDeducao
      group by tdc.nrDivida, tdc.nrAnoDivida
    ) tdce on tdce.nrDivida = filtro.nrDivida and tdce.nrAnoDivida = filtro.nrAnoDivida
    left join (
      select atc.nrDivida,
             atc.nrAnoDivida,
             sum(coalesce(atc.vlArrecadacao, 0)*-1) as vlArrecadacao
      from tcearrecadacaotipocredito atc
      where atc.idtipoorigemreceita = 2
        and atc.idtipoarrecadacao <> 3
      group by atc.nrDivida, atc.nrAnoDivida
    ) atc on atc.nrDivida = filtro.nrDivida and atc.nrAnoDivida = filtro.nrAnoDivida
    left join (
      select atc.nrDivida,
             atc.nrAnoDivida,
             sum(coalesce(atce.vlEstorno, 0)) as vlEstornoArrecadacao
      from tcearrecadacaotipocreditoEst atce
      join tcearrecadacaotipocredito atc on atc.nrAnoArrecadacao = atce.nrAnoArrecadacao and atc.nrArrecadacao = atce.nrArrecadacao
      where atc.idtipoorigemreceita = 2
        and atc.idtipoarrecadacao <> 3
      group by atc.nrDivida, atc.nrAnoDivida
    ) atce on atce.nrDivida = filtro.nrDivida and atce.nrAnoDivida = filtro.nrAnoDivida
    group by filtro.nrdivida,
             filtro.nranodivida
  ) soma
%s
  group by soma.nrAnoDivida,
           soma.nrDivida
) nq