select tribdebitoparcela.iddebitoparcela,
tribdebitoparcela.tipocadastro,
tribdebitoparcela.cadastrogeral,
tribdebitoparcela.exercicio,
tribdebitoparcela.guiarecolhimento as divida,
tribdebitoparcela.subdivida,
tribdebitoparcela.parcela,
case when tribdebito.parcelado = 'S' then tribsituacaoparcela.situacaoparcela || ' - ' || tribsituacaoparcela.descricao || ' Parcelado'
when tribdebito.reparcelado = 'S' then tribsituacaoparcela.situacaoparcela || ' - ' || tribsituacaoparcela.descricao || ' Reparcelado'
else tribsituacaoparcela.situacaoparcela || ' - ' || tribsituacaoparcela.descricao end as situacao,
tribdebitoparcela.situacaolegal,
tribdebitoparcela.datalancamento,
tribdebitoparcela.datavencimento,
sum(coalesce(tribdebitoparcelareceita.valor, 0) +
coalesce(tribdebitoparcelareceita.valorjuros, 0) +
coalesce(tribdebitoparcelareceita.valormulta, 0) +
coalesce(tribdebitoparcelareceita.valorcorrecao, 0) -
coalesce(tribdebitoparcelareceita.valordesconto, 0)) as valor
from tribdebitoparcela tribdebitoparcela
join tribdebito tribdebito
on tribdebitoparcela.entidade = tribdebito.entidade
and tribdebitoparcela.exercicio = tribdebito.exercicio
and tribdebitoparcela.tipocadastro = tribdebito.tipocadastro
and tribdebitoparcela.cadastrogeral = tribdebito.cadastrogeral
and tribdebitoparcela.guiarecolhimento = tribdebito.guiarecolhimento
and tribdebitoparcela.subdivida = tribdebito.subdivida
left join tribsituacaoparcela tribsituacaoparcela
on tribdebitoparcela.situacaodebito = tribsituacaoparcela.situacaoparcela
left join tribdebitoparcelareceita tribdebitoparcelareceita
on tribdebitoparcela.entidade = tribdebitoparcelareceita.entidade
and tribdebitoparcela.exercicio = tribdebitoparcelareceita.exercicio
and tribdebitoparcela.tipocadastro = tribdebitoparcelareceita.tipocadastro
and tribdebitoparcela.cadastrogeral = tribdebitoparcelareceita.cadastrogeral
and tribdebitoparcela.guiarecolhimento = tribdebitoparcelareceita.guiarecolhimento
and tribdebitoparcela.subdivida = tribdebitoparcelareceita.subdivida
and tribdebitoparcela.parcela = tribdebitoparcelareceita.parcela
where tribdebito.constituido = 'S'
and tribsituacaoparcela.tiposituacaoparcela = 1
%s
group by tribdebitoparcela.iddebitoparcela,
tribdebitoparcela.tipocadastro,
tribdebitoparcela.cadastrogeral,
tribdebitoparcela.exercicio,
tribdebitoparcela.guiarecolhimento,
tribdebitoparcela.subdivida,
tribdebitoparcela.parcela,
tribsituacaoparcela.situacaoparcela,
tribsituacaoparcela.descricao,
tribdebitoparcela.situacaolegal,
tribdebitoparcela.datalancamento,
tribdebitoparcela.datavencimento,
tribdebito.parcelado,
tribdebito.reparcelado