select td.entidade,
       acrescimo.dataparcelamento       as datamovimentacao,
       tr.receita                as tributo,
       tr.descricao              as descricaotributo,
       tr.tiporeceita            as tipoTributo,
       case
         when tr.classificacao = 'F'
         then 'J'
         else tr.classificacao
       end                       classificacaotributo,
       case
         when acrescimo.situacaolegal <> 0 and ( acrescimo.datadividaativa is null or acrescimo.datadividaativa <= acrescimo.dataparcelamento )
         then acrescimo.situacaolegal
         else 0
       end                       situacaolegal,
       null                      as tipooperacaodeducao,
       'ACRESCIMOS_PARCELAMENTO' as tipomovimento,
       acrescimo.iddebito,
       p.idunico as idunicopessoa,
       acrescimo.iddebitoparcelareceita,
       acrescimo.valor      as valor
       from (select vap.idparcelamento,
                               vap.iddebitoparcelareceita,
                               vap.receitaorigem,
                               vap.jurosdestino as tributo,
                                case
                                     when vap.parcela = vap.max_parcela then
                                                 vap.valorjuros -
                                                 coalesce((select sum(y.rateio_juros)
                                                           from vw_atualizacao_parcelamento y
                                                           where y.idparcelamento = vap.idparcelamento
                                                             and y.iddebito = vap.iddebito
                                                             and y.receitaorigem = vap.receitaorigem
                                                             and y.parcela <> vap.max_parcela), 0)
                                     else vap.rateio_juros end as valor,
                               vap.iddebito,
                               vap.datadividaativa,
                               vap.situacaolegal,
                               vap.dataparcelamento,
                               vap.parcela
                        from   vw_atualizacao_parcelamento vap
                        where  vap.rateio_juros > 0
                        union
                        select vap.idparcelamento,
                               vap.iddebitoparcelareceita,
                               vap.receitaorigem,
                               vap.multadestino as tributo,
                               case
                                    when vap.parcela = vap.max_parcela then
                                                 vap.valormulta -
                                                 coalesce((select sum(y.rateio_multa)
                                                           from vw_atualizacao_parcelamento y
                                                           where y.idparcelamento = vap.idparcelamento
                                                             and y.iddebito = vap.iddebito
                                                             and y.receitaorigem = vap.receitaorigem
                                                             and y.parcela <> vap.max_parcela), 0)
                                     else vap.rateio_multa end as valor,
                               vap.iddebito,
                               vap.datadividaativa,
                               vap.situacaolegal,
                               vap.dataparcelamento,
                               vap.parcela
                        from   vw_atualizacao_parcelamento vap
                        where  vap.rateio_multa > 0
                        union
                        select vap.idparcelamento,
                               vap.iddebitoparcelareceita,
                               vap.receitaorigem,
                               vap.correcaodestino as tributo,
                               case
                                     when vap.parcela = vap.max_parcela then
                                                 vap.valorcorrecao -
                                                 coalesce((select sum(y.rateio_correcao)
                                                           from vw_atualizacao_parcelamento y
                                                           where y.idparcelamento = vap.idparcelamento
                                                             and y.iddebito = vap.iddebito
                                                             and y.receitaorigem = vap.receitaorigem
                                                             and y.parcela <> vap.max_parcela), 0)
                                     else vap.rateio_correcao end as valor,
                               vap.iddebito,
                               vap.datadividaativa,
                               vap.situacaolegal,
                               vap.dataparcelamento,
                               vap.parcela
                        from   vw_atualizacao_parcelamento vap
                        where  vap.rateio_correcao > 0
                        union
                        select vap.idparcelamento,
                               vap.iddebitoparcelareceita,
                               vap.receitaorigem,
                               vap.jurosfinandestino as tributo,
                               case
                                     when vap.parcela = vap.max_parcela then
                                                vap.valorjurosfinan + vap.juros_financiamento_extra -
                                                 coalesce((select sum(y.rateio_juros_financiamento)
                                                           from vw_atualizacao_parcelamento y
                                                           where y.idparcelamento = vap.idparcelamento
                                                             and y.iddebito = vap.iddebito
                                                             and y.receitaorigem = vap.receitaorigem
                                                             and y.parcela <> vap.max_parcela), 0)
                                     else vap.rateio_juros_financiamento + vap.juros_financiamento_extra end as valor,
                               vap.iddebito,
                               vap.datadividaativa,
                               vap.situacaolegal,
                               vap.dataparcelamento,
                               vap.parcela
                        from   vw_atualizacao_parcelamento vap
                        where  vap.rateio_juros_financiamento > 0) acrescimo
       left outer join tribdebito td
                    on td.iddebito = acrescimo.iddebito
                  join tribcadastrogeral tcg
                    on td.tipocadastro = tcg.tipocadastro
                   and td.cadastrogeral = tcg.cadastrogeral
                  join pessoa p
                    on tcg.pessoa = p.pessoa
       left outer join tribreceita tr
                    on td.entidade = tr.entidade
                   and :exercicio = tr.exercicio
                   and acrescimo.tributo = tr.receita
  where acrescimo.dataparcelamento in (:datasMovimento)
  and td.constituido = 'S'