SELECT A.ENTIDADE,
       A.EXERCICIOPAGAMENTO,
       A.PAGAMENTO,
       A.DATAPAGAMENTO,
       A.DATALANCAMENTO AS DATAMOVIMENTACAO,
       C.VALORPRINCIPAL + COALESCE(C.VALORPAGOMAIOR,0) AS VALORPRINCIPAL,
       C.VALORJUROS,
       C.VALORMULTA,
       C.VALORCORRECAO,
       CASE
          WHEN COALESCE(C.VALORDESCONTOPRINCIPAL,0) + COALESCE(C.VALORDESCONTOJUROS,0) + COALESCE(C.VALORDESCONTOMULTA,0) + COALESCE(C.VALORDESCONTOCORRECAO,0) + COALESCE(C.VALORDESCONTOJUROSFINAN, 0) > 0
             THEN COALESCE(C.VALORDESCONTOPRINCIPAL,0) + COALESCE(C.VALORDESCONTOJUROS,0) + COALESCE(C.VALORDESCONTOMULTA,0) + COALESCE(C.VALORDESCONTOCORRECAO,0) + COALESCE(C.VALORDESCONTOJUROSFINAN, 0)
             ELSE COALESCE(C.VALORDESCONTO,0) + COALESCE(C.VALORPAGOMENOR,0)
       END AS VALORDESCONTO,
       C.VALORPAGOMENOR,
       C.VALORPAGOMAIOR,
       C.VALORPAGO,
       CB.ID AS CONTABANCARIA,
       TDPR.TIPOCADASTRO,
       TDPR.CADASTROGERAL,
       TDPR.EXERCICIO AS EXERCICIODEBITO,
       TDPR.GUIARECOLHIMENTO AS DIVIDA,
       TDPR.SUBDIVIDA
FROM TRIBPAGAMENTO A
LEFT OUTER JOIN TRIBPAGAMENTOBLOQUETO B
 ON A.ENTIDADE = B.ENTIDADE
AND A.EXERCICIOPAGAMENTO = B.EXERCICIOPAGAMENTO
AND A.PAGAMENTO = B.PAGAMENTO
LEFT OUTER JOIN TRIBPAGAMENTODEBITO C
 ON B.IDPAGAMENTOBLOQUETO = C.IDPAGAMENTOBLOQUETO
LEFT OUTER JOIN CONTABANCARIA CB
 ON A.ENTIDADE = CB.ENTIDADE
AND A.CONTABANCARIA = CB.CONTABANCARIA
LEFT OUTER JOIN TRIBDEBITOPARCELARECEITA TDPR
ON C.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA
WHERE CB.INTEGRAARRECADACAO = 'S'