SELECT TRIBCADASTROGERAL.TIPOCADASTRO,
       TRIBCADASTROGERAL.CADASTROGERAL,
       TRIBCADASTROGERAL.PESSOA,
       TRIBDEBITO.ENTIDADE,
       TRIBDEBITO.EXERCICIO,
       TRIBDEBITO.GUIARECOLHIMENTO AS DIVIDA,
       TRIBDEBITO.SUBDIVIDA,
       TRIBDEBITOPARCELARECEITA.RECEITA AS TRIBUTO,
       TRIBDEBITOPARCELA.DATALANCAMENTO,
       TRIBDEBITOPARCELA.DATAVENCIMENTO,
       TRIBDEBITO.DATAPRIMEIRAPARCELA,
       TRIBDEBITOPARCELA.SITUACAOLEGAL,
       TRIBDEBITOPARCELARECEITA.VALOR AS VALORPRINCIPAL,
       TRIBDEBITO.FORMACORRECAO,
       CASE
           WHEN TRIBDEBITO.CONSTITUIDO  = 'S' THEN 1
           ELSE 0
           END AS CONSTITUIDO,
       CASE
           WHEN TRIBDEBITO.PARCELADO = 'S' THEN 1
           ELSE 0
           END AS PARCELADO,
       CASE
           WHEN TRIBDEBITO.REPARCELADO = 'S' THEN 1
           ELSE 0
           END AS REPARCELADO,
       TRIBDEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA,
       TRIBDEBITO.IDDEBITO,
       TRIBDEBITOPARCELARECEITA.PARCELA,
       CASE
           WHEN TRIBGUIARECOLHIMENTO.EMITEBLOQUETO = 'S' THEN 1
           ELSE 0
           END AS EMITEBOLETO,
       TRIBGUIARECOLHIMENTO.DESCRICAO AS DESCRICAODIVIDA,
       TRIBTIPOSITUACAOPARCELA.TIPOSITUACAOPARCELA,
       TRIBDEBITOPARCELA.IDPROTESTO,
       TRIBSITUACAOPARCELA.DESCRICAO AS SITUACAODEBITODESCRICAO,
       TRIBSITUACAOPARCELA.SIGLA AS SITUACAODEBITOSIGLA,
       COALESCE(TRIBDEBITO.NOPROCESSOCOMUMUNICA, CAST(TRIBDEBITOPARCELA.PROCESSOJUDICIAL AS VARCHAR(30))) AS NOPROCESSOCOMUMUNICA,
       TRIBPARCELAMENTO.IDPARCELAMENTO AS IDPARCELAMENTO,
       TRIBPARCELAMENTO.NUMEROCONTRATO AS NUMEROPARCELAMENTO,
       TRIBPARCELAMENTO.ANOCONTRATO AS EXERCICIOPARCELAMENTO,
       tdida.IDCERTIDAO,
       tdida.NUMEROCERTIDAO,
       tdida.EXERCICIOCERTIDAO,
       (
       	SELECT
       		CASE
       			ESTORNADO WHEN 'N' THEN 1
       			ELSE 0
       		END
       	FROM
       		TRIBESTORNOPARCELAMENTO ESTORNOPARC
       	WHERE
       		ESTORNOPARC.IDESTORNOPARCELAMENTO = (
       		SELECT
       			MAX(IDESTORNOPARCELAMENTO)
       		FROM
       			TRIBESTORNOPARCELAMENTODEBITO ESTORNOPARCDEB
       		WHERE
       			ESTORNOPARCDEB.IDDEBITODESTINO = TRIBDEBITO.IDDEBITO)) ORIUNDOESTORNOCONTRATO,
        TRIBPROTESTOREMESSAITEM.CARTORIO as CARTORIO
FROM TRIBDEBITO TRIBDEBITO
         INNER JOIN TRIBDEBITOPARCELA TRIBDEBITOPARCELA ON TRIBDEBITO.ENTIDADE = TRIBDEBITOPARCELA.ENTIDADE
    AND TRIBDEBITO.EXERCICIO = TRIBDEBITOPARCELA.EXERCICIO
    AND TRIBDEBITO.TIPOCADASTRO = TRIBDEBITOPARCELA.TIPOCADASTRO
    AND TRIBDEBITO.CADASTROGERAL = TRIBDEBITOPARCELA.CADASTROGERAL
    AND TRIBDEBITO.GUIARECOLHIMENTO = TRIBDEBITOPARCELA.GUIARECOLHIMENTO
    AND TRIBDEBITO.SUBDIVIDA = TRIBDEBITOPARCELA.SUBDIVIDA
         INNER JOIN TRIBDEBITOPARCELARECEITA TRIBDEBITOPARCELARECEITA ON TRIBDEBITOPARCELARECEITA.ENTIDADE = TRIBDEBITOPARCELA.ENTIDADE
    AND TRIBDEBITOPARCELARECEITA.EXERCICIO = TRIBDEBITOPARCELA.EXERCICIO
    AND TRIBDEBITOPARCELARECEITA.TIPOCADASTRO = TRIBDEBITOPARCELA.TIPOCADASTRO
    AND TRIBDEBITOPARCELARECEITA.CADASTROGERAL = TRIBDEBITOPARCELA.CADASTROGERAL
    AND TRIBDEBITOPARCELARECEITA.GUIARECOLHIMENTO = TRIBDEBITOPARCELA.GUIARECOLHIMENTO
    AND TRIBDEBITOPARCELARECEITA.SUBDIVIDA = TRIBDEBITOPARCELA.SUBDIVIDA
    AND TRIBDEBITOPARCELARECEITA.PARCELA = TRIBDEBITOPARCELA.PARCELA
         INNER JOIN TRIBCADASTROGERAL TRIBCADASTROGERAL ON TRIBDEBITO.TIPOCADASTRO = TRIBCADASTROGERAL.TIPOCADASTRO
    AND TRIBDEBITO.CADASTROGERAL = TRIBCADASTROGERAL.CADASTROGERAL
         INNER JOIN TRIBSITUACAOPARCELA TRIBSITUACAOPARCELA ON TRIBDEBITOPARCELA.SITUACAODEBITO = TRIBSITUACAOPARCELA.SITUACAOPARCELA
         INNER JOIN TRIBTIPOSITUACAOPARCELA TRIBTIPOSITUACAOPARCELA ON TRIBSITUACAOPARCELA.TIPOSITUACAOPARCELA = TRIBTIPOSITUACAOPARCELA.TIPOSITUACAOPARCELA
         LEFT JOIN TRIBGUIARECOLHIMENTO TRIBGUIARECOLHIMENTO ON TRIBGUIARECOLHIMENTO.ENTIDADE = TRIBDEBITO.ENTIDADE
    AND TRIBGUIARECOLHIMENTO.EXERCICIO = TRIBDEBITO.EXERCICIO
    AND TRIBGUIARECOLHIMENTO.GUIARECOLHIMENTO = TRIBDEBITO.GUIARECOLHIMENTO
         LEFT JOIN TRIBPROTESTO TRIBPROTESTO ON TRIBDEBITOPARCELA.IDPROTESTO = TRIBPROTESTO.IDPROTESTO
         LEFT JOIN TRIBPARCELAMENTODEBITO TRIBPARCELAMENTODEBITO ON TRIBPARCELAMENTODEBITO.IDDEBITO = TRIBDEBITO.IDDEBITO
         LEFT JOIN TRIBPARCELAMENTO TRIBPARCELAMENTO ON TRIBPARCELAMENTO.IDPARCELAMENTO = TRIBPARCELAMENTODEBITO.IDPARCELAMENTO
         left outer join (select tdidajoin.entidade,
                                 tdidajoin.exercicio,
                                 tdidajoin.tipodocumento,
                                 tdidajoin.documento,
                                 tdidajoin.exerciciodebito,
                                 tdidajoin.tipocadastro,
                                 tdidajoin.cadastrogeral,
                                 tdidajoin.guiarecolhimento,
                                 tdidajoin.subdivida,
                                 tdidajoin.parcela,
                                 tdidajoin.receita,
                                 doc.idkey as IDCERTIDAO,
                                 doc.documento as NUMEROCERTIDAO,
                                 doc.EXERCICIO AS EXERCICIOCERTIDAO,
                                 doc.cancelado
                          from  tribdocumentoitemdividaativa tdidajoin
                                    inner join tribdocumento doc on (tdidajoin.entidade  = doc.entidade
                              and tdidajoin.exercicio = doc.exercicio
                              and tdidajoin.tipodocumento = doc.tipodocumento
                              and tdidajoin.documento     = doc.documento)
                          where tdidajoin.tipodocumento = 26
                            and (tdidajoin.exercicio, tdidajoin.documento) in
                                (select max(tdidamax.exercicio), max(tdidamax.documento) as ultimodocumento
                                 from tribdocumentoitemdividaativa tdidamax
                                          join tribdocumento docmax on (docmax.entidade = tdidamax.entidade
                                     and  docmax.exercicio = tdidamax.exercicio
                                     and  docmax.tipodocumento = tdidamax.tipodocumento
                                     and  docmax.documento     = tdidamax.documento
                                     and  docmax.cancelado     = 'N')
                                 where tdidamax.entidade       = tdidajoin.entidade
                                   and tdidamax.exerciciodebito  = tdidajoin.exerciciodebito
                                   and tdidamax.tipocadastro     = tdidajoin.tipocadastro
                                   and tdidamax.cadastrogeral    = tdidajoin.cadastrogeral
                                   and tdidamax.guiarecolhimento = tdidajoin.guiarecolhimento
                                   and tdidamax.subdivida        = tdidajoin.subdivida
                                   and tdidamax.parcela          = tdidajoin.parcela
                                   and tdidamax.receita          = tdidajoin.receita
                                   and tdidamax.tipodocumento    = tdidajoin.tipodocumento
                                   and tdidamax.exercicio = (
                                     select max(tdidaexercicio.exercicio)
                                     from tribdocumentoitemdividaativa tdidaexercicio
                                              join tribdocumento docexercicio on (docexercicio.entidade = tdidaexercicio.entidade
                                         and  docexercicio.exercicio = tdidaexercicio.exercicio
                                         and  docexercicio.tipodocumento = tdidaexercicio.tipodocumento
                                         and  docexercicio.documento     = tdidaexercicio.documento
                                         and  docexercicio.cancelado     = 'N')
                                     where tdidaexercicio.entidade       = tdidajoin.entidade
                                       and tdidaexercicio.exerciciodebito  = tdidajoin.exerciciodebito
                                       and tdidaexercicio.tipocadastro     = tdidajoin.tipocadastro
                                       and tdidaexercicio.cadastrogeral    = tdidajoin.cadastrogeral
                                       and tdidaexercicio.guiarecolhimento = tdidajoin.guiarecolhimento
                                       and tdidaexercicio.subdivida        = tdidajoin.subdivida
                                       and tdidaexercicio.parcela          = tdidajoin.parcela
                                       and tdidaexercicio.receita          = tdidajoin.receita
                                       and tdidaexercicio.tipodocumento    = tdidajoin.tipodocumento
                                 )
                                )
                            and doc.cancelado = 'N'
) tdida on (TRIBDEBITOPARCELARECEITA.entidade         = tdida.entidade
    and TRIBDEBITOPARCELARECEITA.exercicio        = tdida.exerciciodebito
    and TRIBDEBITOPARCELARECEITA.tipocadastro     = tdida.tipocadastro
    and TRIBDEBITOPARCELARECEITA.cadastrogeral    = tdida.cadastrogeral
    and TRIBDEBITOPARCELARECEITA.guiarecolhimento = tdida.guiarecolhimento
    and TRIBDEBITOPARCELARECEITA.subdivida        = tdida.subdivida
    and TRIBDEBITOPARCELARECEITA.receita          = tdida.receita
    and TRIBDEBITOPARCELARECEITA.parcela          = tdida.parcela)
LEFT OUTER JOIN TRIBPROTESTOREMESSAITEM TRIBPROTESTOREMESSAITEM ON
    (TRIBPROTESTOREMESSAITEM.idprotesto = TRIBDEBITOPARCELA.idprotesto
    AND TRIBPROTESTOREMESSAITEM.entidade = TRIBPROTESTO.entidade
    AND TRIBPROTESTOREMESSAITEM.exercicio = TRIBPROTESTO.exercicio
    AND TRIBPROTESTOREMESSAITEM.remessa = (
    	select max(tprimax.remessa)
    	from tribprotestoremessaitem tprimax
    	where tprimax.idprotesto = TRIBDEBITOPARCELA.idprotesto)
    AND TRIBPROTESTOREMESSAITEM.sequencia = (
    	select max(tprimax.sequencia)
    	from tribprotestoremessaitem tprimax
    	where tprimax.idprotesto = TRIBDEBITOPARCELA.idprotesto
    	and tprimax.remessa = TRIBPROTESTOREMESSAITEM.remessa))
WHERE TRIBDEBITO.ENTIDADE = 1
  AND TRIBTIPOSITUACAOPARCELA.TIPO = 'A'
  AND TRIBDEBITOPARCELARECEITA.VALOR > 0
  AND TRIBCADASTROGERAL.EXCLUSAOLOGICA = 'N'