/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import br.com.elotech.core.exception.EloValidationException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import lombok.Generated;

public final class FileUtils {
    public static byte[] zipBytes(String filename, byte[] input) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        ZipEntry zipEntry = new ZipEntry(filename);
        try {
            zipEntry.setSize(input.length);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(input);
            zipOutputStream.closeEntry();
            zipOutputStream.close();
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao compactar arquivo em .zip.");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static File createTempFile(String nome, String extensao, byte[] content) throws IOException {
        Objects.requireNonNull(nome, "O nome do arquivo tempor\u00e1rio precisa ser informado.");
        Objects.requireNonNull(extensao, "A extens\u00e3o do arquivo tempor\u00e1rio precisa ser informada.");
        Path path = Files.createTempFile(nome, extensao, new FileAttribute[0]);
        return Files.write(path, content, StandardOpenOption.CREATE).toFile();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String unzipFileToString(byte[] bytes, String nomeArquivo) {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
            String string;
            try (ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);){
                ZipEntry arquivo;
                StringBuilder conteudoArquivo = new StringBuilder();
                while ((arquivo = zipInputStream.getNextEntry()) != null) {
                    String linha;
                    if (!arquivo.getName().equals(nomeArquivo)) continue;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)zipInputStream, StandardCharsets.UTF_8));
                    while ((linha = bufferedReader.readLine()) != null) {
                        conteudoArquivo.append(linha).append("\n");
                    }
                    zipInputStream.closeEntry();
                }
                string = conteudoArquivo.toString();
            }
            return string;
        }
        catch (Exception e) {
            throw new EloValidationException(String.format("Falha ao descompactar arquivo zip. Erro: %s", e.getMessage()));
        }
    }

    public static String getFileExtension(String fileName) {
        if (Objects.isNull(fileName) || fileName.trim().isEmpty()) {
            throw new EloValidationException("Nome do arquivo inv\u00e1lido.");
        }
        int ultimoPonto = fileName.lastIndexOf(46);
        if (ultimoPonto == -1) {
            throw new EloValidationException("Extens\u00e3o do arquivo n\u00e3o encontrada.");
        }
        if (ultimoPonto == 0 || ultimoPonto == fileName.length() - 1) {
            throw new EloValidationException("Extens\u00e3o do arquivo inv\u00e1lida.");
        }
        return fileName.substring(ultimoPonto + 1);
    }

    @Generated
    private FileUtils() {
    }
}

