/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.Objects;

public final class DateUtils {
    public static final Integer DAYS_PER_MONTH = 30;
    public static final Double DAYS_PER_MONTH_INCOMP = 30.4375;
    public static final Double DAYS_YEAR_INCOMP = 365.25;
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter DATE_TIME_FORMATTER_FORMATO_BRASILEIRO = DateTimeFormatter.ofPattern("dd-MM-yyyy");

    private DateUtils() {
    }

    public static Long daysBetween(LocalDate startDate, LocalDate endDate) {
        return startDate.until(endDate, ChronoUnit.DAYS);
    }

    public static Long monthsBetween(LocalDate startDate, LocalDate endDate) {
        return startDate.withDayOfMonth(1).until(endDate.withDayOfMonth(1), ChronoUnit.MONTHS);
    }

    public static Long monthsBetween(YearMonth startDate, YearMonth endDate) {
        return startDate.until(endDate, ChronoUnit.MONTHS);
    }

    public static Long monthsBetweenDelphi(LocalDate startDate, LocalDate endDate) {
        Long dateDiff = startDate.getDayOfMonth() == endDate.getDayOfMonth() ? -1L : 0L;
        return startDate.until(endDate, ChronoUnit.MONTHS) + dateDiff;
    }

    public static Long yearsBetweenDelphi(LocalDate startDate, LocalDate endDate) {
        return (long)Math.floor((double)(endDate.toEpochDay() - startDate.toEpochDay()) / DAYS_YEAR_INCOMP);
    }

    public static LocalDate stringToLocalDate(String date) {
        if (date.matches("\\d{4}-\\d{2}-\\d{2}")) {
            return LocalDate.parse(date, DATE_TIME_FORMATTER);
        }
        if (date.matches("\\d{2}/\\d{2}/\\d{4}")) {
            String replacedDate = date.replace("/", "-");
            return LocalDate.parse(replacedDate, DATE_TIME_FORMATTER_FORMATO_BRASILEIRO);
        }
        if (date.matches("\\d{2}-\\d{2}-\\d{4}")) {
            return LocalDate.parse(date, DATE_TIME_FORMATTER_FORMATO_BRASILEIRO);
        }
        throw new DateTimeParseException("Formato de Data inv\u00e1lida.", date, 0);
    }

    public static String localDateToString(LocalDate data) {
        return DATE_TIME_FORMATTER.format(data);
    }

    public static String localDateToCompetenciaStringFormatoBrasileiro(LocalDate data) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("MM/yyyy");
        return df.format(data);
    }

    public static String localDateToStringFormatoBrasileiro(LocalDate data) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("dd/MM/yyyy");
        return df.format(data);
    }

    public static String localDateTimeToStringFormatoBrasileiro(LocalDateTime data) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
        return df.format(data);
    }

    public static Boolean isVencido(LocalDate data) {
        LocalDate dataHoje = LocalDate.now();
        if (Objects.nonNull(data)) {
            return data.isBefore(dataHoje);
        }
        return Boolean.FALSE;
    }

    public static LocalDate dateToLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Date localDateToDate(LocalDate date) {
        return Date.from(date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date localDateTimeToDate(LocalDateTime date) {
        return Date.from(date.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate getLocalDateComUltimoDiaDoMes(LocalDate value) {
        return value.with(TemporalAdjusters.lastDayOfMonth());
    }
}

