/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.unico;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.repository.LogradouroRepository;
import br.com.elotech.tributos.service.LogradouroService;
import br.com.elotech.tributos.service.unico.LogradouroClientUnico;
import br.com.elotech.tributos.util.ConvertToUpperCase;
import br.com.elotech.unico.client.dto.CidadeDTO;
import br.com.elotech.unico.client.dto.LogradouroDTO;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class LogradouroServiceUnico
extends CrudService<Logradouro, Long>
implements LogradouroService {
    private LogradouroRepository logradouroRepository;
    private LogradouroClientUnico logradouroClientUnico;

    public LogradouroServiceUnico(LogradouroRepository logradouroRepository, LogradouroClientUnico logradouroClientUnico) {
        this.logradouroRepository = logradouroRepository;
        this.logradouroClientUnico = logradouroClientUnico;
    }

    public Optional<Logradouro> buscaOuCriaLogradouro(br.com.elotech.tributos.dto.LogradouroDTO logradouroDTO) {
        if (StringUtils.isBlank((CharSequence)logradouroDTO.getDescricao())) {
            return Optional.empty();
        }
        ConvertToUpperCase.convert((Object)logradouroDTO);
        if (Objects.nonNull(logradouroDTO.getId())) {
            return this.logradouroRepository.findByCidadeIdAndLogradouro(logradouroDTO.getIdCidade(), logradouroDTO.getId());
        }
        List logradouros = this.logradouroRepository.findByCidadeIdAndDescricaoIgnoreCase(logradouroDTO.getIdCidade(), logradouroDTO.getDescricao());
        if (!logradouros.isEmpty()) {
            return logradouros.stream().min(Comparator.comparing(Logradouro::getInativo));
        }
        if (Objects.nonNull(logradouroDTO.getIdCidadeUnico())) {
            CidadeDTO cidadeDTO = new CidadeDTO();
            cidadeDTO.setId(logradouroDTO.getIdCidadeUnico());
            LogradouroDTO novoLogradouro = new LogradouroDTO();
            novoLogradouro.setDescricao(logradouroDTO.getDescricao());
            novoLogradouro.setCidade(cidadeDTO);
            LogradouroDTO logradouroUnicoCriado = this.logradouroClientUnico.saveLogradouro(novoLogradouro);
            return this.logradouroRepository.findByIdunico(logradouroUnicoCriado.getId());
        }
        return Optional.empty();
    }

    public Optional<Logradouro> findByLogradouroAndCidadeEntidadePrincipal(Long codigo) {
        return this.logradouroRepository.findByLogradouroAndCidadeEntidadePrincipal(codigo);
    }

    public Page<Logradouro> findAllByCidadeEntidadePrincipal(Pageable page) {
        return this.logradouroRepository.findAllByCidadeEntidadePrincipal(page);
    }
}

