/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.validacaoregrasimportacao;

import br.com.elotech.tributos.domain.simam.validacoes.ErrosImportacaoSIMAM;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.EstornoArrecadacaoCreditoValidacao;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.batch.core.StepExecution;
import org.springframework.stereotype.Service;

@Service
public class EstornoArrecadacaoCreditoValidacaoSimAmService {
    public List<ErrosImportacaoSIMAM> validateEstorno(EstornoArrecadacaoCreditoValidacao estorno, StepExecution stepExecution) {
        ArrayList<ErrosImportacaoSIMAM> erros = new ArrayList<ErrosImportacaoSIMAM>();
        LocalDate dataTrabalho = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobParameters().getDate("dataFinal")));
        this.validaDuplicado(estorno, erros);
        this.validaSequenciaNrEstorno(estorno, erros);
        this.validaSeExisteArrecadacaoParaEstorno(estorno, erros);
        this.validaSeTemMaisDeUmEstornoParaUmaMesmaArrecadacao(estorno, erros);
        this.validaEstornoDeArrecadacaoDoExercicioDeTrabalho(estorno, erros, dataTrabalho);
        return erros;
    }

    private void validaDuplicado(EstornoArrecadacaoCreditoValidacao estorno, List<ErrosImportacaoSIMAM> erros) {
        if (estorno.isDuplicado()) {
            String message = "O conjunto (nrEstorno e nrAnoEstorno) declarado na  tabela (EstornoArrecadacaoCredito) apresenta-se com registro duplicado.";
            Long codigoErro = 2110L;
            erros.add(ErrosImportacaoSIMAM.estornoArrecadacao((EstornoArrecadacaoCreditoValidacao)estorno, (String)message, (Long)codigoErro));
        }
    }

    private void validaSequenciaNrEstorno(EstornoArrecadacaoCreditoValidacao estorno, List<ErrosImportacaoSIMAM> erros) {
        if (!estorno.isSequencial()) {
            String message = "O N\u00famero e Ano do Estorno (nrEstorno e nrAnoEstorno) declarados na tabela (EstornoArrecadacaoCredito) n\u00e3o pode apresentar quebra da ordem sequencial no ano de trabalho.";
            Long codigoErro = 2111L;
            erros.add(ErrosImportacaoSIMAM.estornoArrecadacao((EstornoArrecadacaoCreditoValidacao)estorno, (String)message, (Long)codigoErro));
        }
    }

    private void validaSeExisteArrecadacaoParaEstorno(EstornoArrecadacaoCreditoValidacao estorno, List<ErrosImportacaoSIMAM> erros) {
        if (!estorno.isArrecadacaoValida()) {
            String message = "A combina\u00e7\u00e3o (nrArrecadacao e nrAnoArrecadacao) declarada na tabela (EstornoArrecadacaoCredito) n\u00e3o existe na tabela (ArrecadacaoCredito).";
            Long codigoErro = 2112L;
            erros.add(ErrosImportacaoSIMAM.estornoArrecadacao((EstornoArrecadacaoCreditoValidacao)estorno, (String)message, (Long)codigoErro));
        }
    }

    private void validaSeTemMaisDeUmEstornoParaUmaMesmaArrecadacao(EstornoArrecadacaoCreditoValidacao estorno, List<ErrosImportacaoSIMAM> erros) {
        if (!estorno.isEstornoUnico()) {
            String message = "O registro declarado na tabela (EstornoArrecadacaoCredito) para o conjunto (nrAnoEstorno, nrArrecadacao, nrAnoArrecadacao, nrMes e nrAno) n\u00e3o pode ser duplicado.";
            Long codigoErro = 2240L;
            erros.add(ErrosImportacaoSIMAM.estornoArrecadacao((EstornoArrecadacaoCreditoValidacao)estorno, (String)message, (Long)codigoErro));
        }
    }

    private void validaEstornoDeArrecadacaoDoExercicioDeTrabalho(EstornoArrecadacaoCreditoValidacao estorno, List<ErrosImportacaoSIMAM> erros, LocalDate dataTrabalho) {
        if (!estorno.isEstornoDeArrecadacaoDoPeriodoDeTrabalho(dataTrabalho)) {
            String message = "O registro declarado na tabela (EstornoArrecadacaoCredito) n\u00e3o pode estar vinculado com ano de arrecada\u00e7\u00e3o (nrAnoArrecadacao) menor que o exerc\u00edcio financeiro de " + dataTrabalho.getYear();
            Long codigoErro = 2254L;
            erros.add(ErrosImportacaoSIMAM.estornoArrecadacao((EstornoArrecadacaoCreditoValidacao)estorno, (String)message, (Long)codigoErro));
        }
    }
}

