/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class EstornoLancamentoCreditoJobStarter {
    private final ObjectMapper objectMapper;
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final Job estornoLancamentoCreditoJob;
    private final EntidadeRepository entidadeRepository;

    public EstornoLancamentoCreditoJobStarter(ObjectMapper objectMapper, JobLauncher jobLauncher, JobExplorer jobExplorer, @Qualifier(value="estornoLancamentoCreditoBatchJob") Job estornoLancamentoCreditoBatchJob, EntidadeRepository entidadeRepository) {
        this.objectMapper = objectMapper;
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.estornoLancamentoCreditoJob = estornoLancamentoCreditoBatchJob;
        this.entidadeRepository = entidadeRepository;
    }

    public JobExecution startJob(Long idEntidade, LocalDate dataInicial, LocalDate dataFinal) throws Exception {
        Boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.SIMAM_ESTORNO_LANCAMENTO_CREDITO.getTipo()).stream().anyMatch(job -> dataInicial.equals(DateUtils.dateToLocalDate((Date)Objects.requireNonNull(job.getJobParameters().getDate("dataInicial")))) && dataFinal.equals(DateUtils.dateToLocalDate((Date)Objects.requireNonNull(job.getJobParameters().getDate("dataFinal")))));
        if (Boolean.TRUE.equals(existeJobNaoFinalizadoComMesmoFiltro)) {
            throw new EloValidationException("J\u00e1 existe um job com estes par\u00e2metros.");
        }
        Entidade entidade = (Entidade)this.entidadeRepository.findById((Object)idEntidade).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel localizar a entidade com id %d", idEntidade)));
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("entidade", entidade.getId());
        jobParametersBuilder.addString("idPessoa", entidade.getIdentificacaoTce());
        jobParametersBuilder.addDate("dataInicial", DateUtils.localDateToDate((LocalDate)dataInicial));
        jobParametersBuilder.addDate("dataFinal", DateUtils.localDateToDate((LocalDate)dataFinal));
        jobParametersBuilder.addDate("dataReferencia", new Date());
        return this.jobLauncher.run(this.estornoLancamentoCreditoJob, jobParametersBuilder.toJobParameters());
    }
}

