/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acrescimo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.acrescimo.IndiceCorrecao;
import br.com.elotech.tributos.dto.acrescimo.CalculaValorIndiceMensalDTO;
import br.com.elotech.tributos.service.acrescimo.IndiceCorrecaoService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class IndiceCorrecaoService
extends CrudService<IndiceCorrecao, Long> {
    protected void beforeSave(IndiceCorrecao entity, Authentication authentication) {
        entity.setVinculoValor();
    }

    public CalculaValorIndiceMensalDTO calcularValorIndiceMensal(CalculaValorIndiceMensalDTO dto) {
        switch (1.$SwitchMap$br$com$elotech$tributos$enums$TipoCalculoValorIndiceMensal[dto.getTipoCalculo().ordinal()]) {
            case 1: {
                return this.calcularNovoValorIndiceMensal(dto);
            }
            case 2: {
                return this.calcularPercentualVariacaoIndiceMensal(dto);
            }
        }
        throw new EloValidationException("Tipo de c\u00e1lculo do \u00edndice mensal inv\u00e1lido");
    }

    public CalculaValorIndiceMensalDTO calcularNovoValorIndiceMensal(CalculaValorIndiceMensalDTO dto) {
        if (dto.getData() != null && dto.getValorPercentualVariacao() != null) {
            BigDecimal valorMesAnterior = dto.getValorIndiceMesAnterior();
            BigDecimal valorVariacao = valorMesAnterior.multiply(dto.getValorPercentualVariacao()).divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_UP);
            BigDecimal novoValorIndice = valorMesAnterior.add(valorVariacao);
            dto.setValor(novoValorIndice);
        }
        return dto;
    }

    public CalculaValorIndiceMensalDTO calcularPercentualVariacaoIndiceMensal(CalculaValorIndiceMensalDTO dto) {
        BigDecimal valorMesAnterior;
        if (dto.getData() != null && dto.getValor() != null && !Objects.equals(valorMesAnterior = dto.getValorIndiceMesAnterior(), BigDecimal.ZERO)) {
            BigDecimal valorDiferenca = dto.getValor().subtract(valorMesAnterior);
            BigDecimal novoPercentualVariacao = valorDiferenca.multiply(BigDecimal.valueOf(100L)).divide(valorMesAnterior, 4, RoundingMode.HALF_UP);
            dto.setValorPercentualVariacao(novoPercentualVariacao);
        }
        return dto;
    }

    @Generated
    public IndiceCorrecaoService() {
    }
}

