/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.domain.totem.PagamentoBoletoTotem;
import br.com.elotech.tributos.dto.totem.PagamentoBoletoTotemRequestDTO;
import br.com.elotech.tributos.dto.totem.PagamentoBoletoTotemResponseDTO;
import br.com.elotech.tributos.repository.PagamentoBoletoTotemRepository;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PagamentoBoletoTotemService
extends CrudService<PagamentoBoletoTotem, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PagamentoBoletoTotemService.class);
    private final ObjectMapper objectMapper;
    private final PagamentoBoletoTotemRepository pagamentoBoletoTotemRepository;
    private final BloquetoService bloquetoService;
    private final DebitoParcelaService debitoParcelaService;
    private final SituacaoParcelaService situacaoParcelaService;

    public PagamentoBoletoTotemService(ObjectMapper objectMapper, PagamentoBoletoTotemRepository pagamentoBoletoTotemRepository, BloquetoService bloquetoService, DebitoParcelaService debitoParcelaService, SituacaoParcelaService situacaoParcelaService) {
        this.objectMapper = objectMapper;
        this.pagamentoBoletoTotemRepository = pagamentoBoletoTotemRepository;
        this.bloquetoService = bloquetoService;
        this.debitoParcelaService = debitoParcelaService;
        this.situacaoParcelaService = situacaoParcelaService;
    }

    public PagamentoBoletoTotemResponseDTO createPagamentoBoleto(JsonNode payload) {
        PagamentoBoletoTotemRequestDTO request;
        try {
            request = (PagamentoBoletoTotemRequestDTO)this.objectMapper.treeToValue((TreeNode)payload, PagamentoBoletoTotemRequestDTO.class);
        }
        catch (JsonProcessingException exception) {
            String motivoErro = "Erro ao converter a requisi\u00e7\u00e3o da confirma\u00e7\u00e3o de pagamento: ";
            LOGGER.error("{} {}", new Object[]{motivoErro, payload, exception});
            PagamentoBoletoTotem pagamentoBoletoTotem = PagamentoBoletoTotem.createSituacaoErro(null, null, (String)(motivoErro + exception.getMessage()), (JsonNode)payload);
            return this.save(pagamentoBoletoTotem);
        }
        Optional boleto = this.bloquetoService.findByNossoNumero(request.getNossoNumero());
        if (boleto.isEmpty()) {
            String motivoErro = String.format("N\u00e3o existe boleto com o nossoNumero: %s.", request.getNossoNumero());
            LOGGER.error(motivoErro);
            PagamentoBoletoTotem pagamentoBoletoTotem = PagamentoBoletoTotem.createSituacaoErro((PagamentoBoletoTotemRequestDTO)request, null, (String)motivoErro, (JsonNode)payload);
            return this.save(pagamentoBoletoTotem);
        }
        this.verifyPagamentoBoletoExistente((Bloqueto)boleto.get());
        try {
            this.verifyValorPagamentoBoleto(request, ((Bloqueto)boleto.get()).getValorBloqueto());
            this.updateSituacaoDebitoParcela((Bloqueto)boleto.get(), request.getObservacao());
        }
        catch (Exception exception) {
            String motivoErro = "Erro ao processar a confirma\u00e7\u00e3o de pagamento: ";
            LOGGER.error("{} [{}]", new Object[]{motivoErro, request, exception});
            return this.save(PagamentoBoletoTotem.createSituacaoErro((PagamentoBoletoTotemRequestDTO)request, (Bloqueto)((Bloqueto)boleto.get()), (String)(motivoErro + exception.getMessage()), (JsonNode)payload));
        }
        return this.save(PagamentoBoletoTotem.createSituacaoConfirmado((PagamentoBoletoTotemRequestDTO)request, (Bloqueto)((Bloqueto)boleto.get()), (JsonNode)payload));
    }

    public PagamentoBoletoTotemResponseDTO findPagamentoBoletoTotem(String nossoNumero) {
        Bloqueto boleto = (Bloqueto)this.bloquetoService.findByNossoNumero(nossoNumero).orElseThrow(() -> RestException.notFound((String)String.format("N\u00e3o existe boleto com o nossoNumero: %s.", nossoNumero)));
        PagamentoBoletoTotem pagamentoBoletoTotem = Optional.ofNullable(this.pagamentoBoletoTotemRepository.findByBoletoId(boleto.getId())).orElseThrow(() -> RestException.notFound((String)String.format("N\u00e3o existe pagamento para o boleto com nossoNumero: %s", nossoNumero)));
        return PagamentoBoletoTotemResponseDTO.of((PagamentoBoletoTotem)pagamentoBoletoTotem);
    }

    public PagamentoBoletoTotemResponseDTO save(PagamentoBoletoTotem pagamentoBoletoTotem) {
        return PagamentoBoletoTotemResponseDTO.of((PagamentoBoletoTotem)((PagamentoBoletoTotem)this.pagamentoBoletoTotemRepository.save((Object)pagamentoBoletoTotem)));
    }

    private void verifyPagamentoBoletoExistente(Bloqueto boleto) {
        PagamentoBoletoTotem pagamentoBoletoTotemFound = this.pagamentoBoletoTotemRepository.findByBoletoId(boleto.getId());
        if (Objects.nonNull(pagamentoBoletoTotemFound)) {
            String mensagem = String.format("Pagamento de boleto j\u00e1 registrado com ID %d", pagamentoBoletoTotemFound.getId());
            LOGGER.error(mensagem);
            throw new EloValidationException(mensagem);
        }
    }

    private void verifyValorPagamentoBoleto(PagamentoBoletoTotemRequestDTO request, BigDecimal valorBoleto) {
        if (Objects.isNull(request.getValor()) || request.getValor().compareTo(valorBoleto) != 0) {
            String mensagem = Objects.isNull(request.getValor()) ? String.format("Valor nulo de pagamento do boleto com valor %.2f com o nossoNumero: %s.", valorBoleto, request.getNossoNumero()) : String.format("Valor de pagamento %.2f incompat\u00edvel com o valor do boleto %.2f com o nossoNumero: %s.", request.getValor(), valorBoleto, request.getNossoNumero());
            LOGGER.error(mensagem);
            throw new EloValidationException(mensagem);
        }
    }

    private void updateSituacaoDebitoParcela(Bloqueto boleto, String observacao) {
        SituacaoParcela situacaoParcelaPagoTotem = this.situacaoParcelaService.findSituacaoParcelaPagoTotem(boleto.getEntidade());
        boleto.getDebitos().forEach(boletoDebito -> {
            DebitoParcela debitoParcela = boletoDebito.getId().getDebitoParcelaTributo().getDebitoParcela();
            if (debitoParcela.getSituacaoDebito().getTipoSituacaoParcela().isAberto()) {
                LOGGER.debug("Atualiza\u00e7\u00e3o do pagamento totem do d\u00e9bito parcela: [{}]", (Object)debitoParcela.getId());
                this.debitoParcelaService.updateDebitoParcelaPagamentoTotem(debitoParcela, situacaoParcelaPagoTotem, observacao);
            }
        });
    }
}

